<?php
/*
 * Plugin Name: WPGeared LLMs.txt Generator
 * Plugin URI: https://wordpress.org/plugins/wpgeared-llms-txt-generator/
 * Description: Generate llms.txt for ChatGPT, Claude, Perplexity & AI models. Supports Yoast, Rank Math, AIOSEO & SEOPress.
 * Version: 1.2.7
 * Author: Aamir Faiz
 * Author URI: https://wpgeared.com
 * License: GPLv2 or later
 * Text Domain: wpgeared-llms-txt-generator
 * Domain Path: /languages
 */

// If this file is called directly, abort.
if (!defined('ABSPATH')) {
	exit;
}

// Define plugin constants
define('WPG_LLMSTXT_VERSION', '1.2.7');
define('WPG_LLMSTXT_PATH', plugin_dir_path(__FILE__));
define('WPG_LLMSTXT_URL', plugin_dir_url(__FILE__));
define('WPG_LLMSTXT_BASENAME', plugin_basename(__FILE__));

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require_once WPG_LLMSTXT_PATH . 'includes/class-wpgeared-llms-txt-generator.php';

/**
 * Activation hook
 */
function wpg_llmstxt_activate()
{
	require_once WPG_LLMSTXT_PATH . 'includes/class-wpgeared-llms-txt-generator.php';
	WPG_LLMsTxt_Manager::activate();
}
register_activation_hook(__FILE__, 'wpg_llmstxt_activate');

/**
 * Deactivation hook
 */
function wpg_llmstxt_deactivate()
{
	require_once WPG_LLMSTXT_PATH . 'includes/class-wpgeared-llms-txt-generator.php';
	WPG_LLMsTxt_Manager::deactivate();
}
/**
 * Run the plugin
 */
function wpg_llmstxt_run()
{
	// Check PHP version
	if (version_compare(PHP_VERSION, '7.4', '<')) {
		add_action('admin_notices', 'wpg_llmstxt_php_version_notice');
		return;
	}

	// Check WordPress version
	if (version_compare(get_bloginfo('version'), '5.8', '<')) {
		add_action('admin_notices', 'wpg_llmstxt_wp_version_notice');
		return;
	}

	/**
	 * The core plugin class that is used to define internationalization,
	 * admin-specific hooks, and public-facing site hooks.
	 */
	require_once WPG_LLMSTXT_PATH . 'includes/class-wpgeared-llms-txt-generator.php';

	/**
	 * Begins execution of the plugin.
	 */
	$plugin = new WPG_LLMsTxt_Manager();
	$plugin->run();
}
add_action('plugins_loaded', 'wpg_llmstxt_run');

/**
 * Display PHP version notice.
 */
function wpg_llmstxt_php_version_notice()
{
	?>
	<div class="notice notice-error">
		<p><?php esc_html_e('WPGeared LLMs.txt Generator requires PHP version 7.4 or higher. Please upgrade your PHP version.', 'wpgeared-llms-txt-generator'); ?>
		</p>
	</div>
	<?php
}

/**
 * Display WordPress version notice.
 */
function wpg_llmstxt_wp_version_notice()
{
	?>
	<div class="notice notice-error">
		<p><?php esc_html_e('WPGeared LLMs.txt Generator requires WordPress version 5.8 or higher. Please upgrade WordPress.', 'wpgeared-llms-txt-generator'); ?>
		</p>
	</div>
	<?php
}
