<?php
/**
 * Fired when the plugin is uninstalled.
 *
 * @package WPG_LLMsTxt_Manager
 */

// If uninstall not called from WordPress, then exit.
if (!defined('WP_UNINSTALL_PLUGIN')) {
	exit;
}

global $wpdb;

// Delete options
$wpg_llmstxt_options = array(
	'wpg_llmstxt_enabled',
	'wpg_llmstxt_post_types',
	'wpg_llmstxt_include_categories',
	'wpg_llmstxt_include_tags',
	'wpg_llmstxt_site_description',
	'wpg_llmstxt_excluded_ids',
	'wpg_llmstxt_crawler_detection',
	'wpg_llmstxt_cache_duration',
	'wpg_llmstxt_flush_rewrite_rules',
);

foreach ($wpg_llmstxt_options as $wpg_llmstxt_option) {
	delete_option($wpg_llmstxt_option);
}

// Delete transients
$wpg_llmstxt_transients = array(
	'wpg_llmstxt_content',
	'_transient_wpg_llmstxt_content',
	'_transient_timeout_wpg_llmstxt_content',
);

foreach ($wpg_llmstxt_transients as $wpg_llmstxt_transient) {
	delete_transient($wpg_llmstxt_transient);
}

// Delete crawler logs table
$wpg_llmstxt_table_name = $wpdb->prefix . 'wpg_llmstxt_crawler_logs';
// phpcs:disable WordPress.DB.PreparedSQL.NotPrepared, WordPress.DB.PreparedSQL.InterpolatedNotPrepared, WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.SchemaChange, PluginCheck.Security.DirectDB.UnescapedDBParameter, WordPress.DB.DirectDatabaseQuery.NoCaching
$wpdb->query("DROP TABLE IF EXISTS `{$wpg_llmstxt_table_name}`");
// phpcs:enable WordPress.DB.PreparedSQL.NotPrepared, WordPress.DB.PreparedSQL.InterpolatedNotPrepared, WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.SchemaChange, PluginCheck.Security.DirectDB.UnescapedDBParameter, WordPress.DB.DirectDatabaseQuery.NoCaching

// Flush rewrite rules
flush_rewrite_rules();
