<?php
/**
 * The public-facing functionality of the plugin.
 *
 * @package WPG_LLMsTxt_Manager
 */

// If this file is called directly, abort.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Public class.
 */
class WPG_LLMsTxt_Manager_Public {

	/**
	 * The ID of this plugin.
	 *
	 * @var string
	 */
	private $plugin_name;

	/**
	 * The version of this plugin.
	 *
	 * @var string
	 */
	private $version;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @param string $plugin_name The name of this plugin.
	 * @param string $version      The version of this plugin.
	 */
	public function __construct( $plugin_name, $version ) {
		$this->plugin_name = $plugin_name;
		$this->version     = $version;
	}

	/**
	 * Detect AI crawlers and log visits.
	 */
	public function detect_crawlers() {
		$detector = new WPG_LLMsTxt_Manager_Crawler_Detector();
		$crawler  = $detector->detect();

		if ( $crawler ) {
			$detector->log_visit( $crawler );
		}
	}
}

