<?php
/**
 * SEO plugin integration class.
 *
 * @package WPG_LLMsTxt_Manager
 */

// If this file is called directly, abort.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * SEO Integration class.
 */
class WPG_LLMsTxt_Manager_SEO_Integration {

	/**
	 * Check if a post should be excluded based on SEO plugin settings.
	 *
	 * @param int $post_id Post ID.
	 * @return bool True if post should be excluded, false otherwise.
	 */
	public function should_exclude_post( $post_id ) {
		// Check Yoast SEO
		if ( $this->is_yoast_active() ) {
			$noindex = get_post_meta( $post_id, '_yoast_wpseo_meta-robots-noindex', true );
			if ( '1' === $noindex ) {
				return true;
			}
		}

		// Check Rank Math
		if ( $this->is_rankmath_active() ) {
			$noindex = get_post_meta( $post_id, 'rank_math_robots', true );
			if ( is_array( $noindex ) && in_array( 'noindex', $noindex, true ) ) {
				return true;
			}
			$noindex = get_post_meta( $post_id, 'rank_math_robots', true );
			if ( 'noindex' === $noindex ) {
				return true;
			}
		}

		// Check AIOSEO
		if ( $this->is_aioseo_active() ) {
			$robots = get_post_meta( $post_id, '_aioseo_robots_noindex', true );
			if ( true === $robots || '1' === $robots ) {
				return true;
			}
		}

		// Check SEOPress
		if ( $this->is_seopress_active() ) {
			$noindex = get_post_meta( $post_id, '_seopress_robots_index', true );
			if ( 'yes' === $noindex ) {
				return true;
			}
		}

		return false;
	}

	/**
	 * Check if Yoast SEO is active.
	 *
	 * @return bool True if active, false otherwise.
	 */
	public function is_yoast_active() {
		return defined( 'WPSEO_VERSION' );
	}

	/**
	 * Check if Rank Math is active.
	 *
	 * @return bool True if active, false otherwise.
	 */
	public function is_rankmath_active() {
		return defined( 'RANK_MATH_VERSION' );
	}

	/**
	 * Check if AIOSEO is active.
	 *
	 * @return bool True if active, false otherwise.
	 */
	public function is_aioseo_active() {
		return defined( 'AIOSEO_VERSION' );
	}

	/**
	 * Check if SEOPress is active.
	 *
	 * @return bool True if active, false otherwise.
	 */
	public function is_seopress_active() {
		return defined( 'SEOPRESS_VERSION' );
	}

	/**
	 * Get list of active SEO plugins.
	 *
	 * @return array List of active SEO plugin names.
	 */
	public function get_active_plugins() {
		$active = array();

		if ( $this->is_yoast_active() ) {
			$active[] = 'Yoast SEO';
		}
		if ( $this->is_rankmath_active() ) {
			$active[] = 'Rank Math';
		}
		if ( $this->is_aioseo_active() ) {
			$active[] = 'All in One SEO';
		}
		if ( $this->is_seopress_active() ) {
			$active[] = 'SEOPress';
		}

		return $active;
	}
}

