<?php
/**
 * Settings page view - Professional Redesign
 *
 * @package WPG_LLMsTxt_Manager
 */

// If this file is called directly, abort.
if (!defined('ABSPATH')) {
	exit;
}

$wpg_llmstxt_generator = new WPG_LLMsTxt_Manager_Generator();
$wpg_llmstxt_cache = new WPG_LLMsTxt_Manager_Cache();
$wpg_llmstxt_seo = new WPG_LLMsTxt_Manager_SEO_Integration();
$wpg_llmstxt_detector = new WPG_LLMsTxt_Manager_Crawler_Detector();
$wpg_llmstxt_stats = $wpg_llmstxt_detector->get_statistics(30);
$wpg_llmstxt_cache_stats = $wpg_llmstxt_cache->get_stats();
$wpg_llmstxt_active_seo = $wpg_llmstxt_seo->get_active_plugins();
?>

<div class="wpg_llmstxt-wrap">
	<!-- Header -->
	<div class="wpg_llmstxt-header">
		<h1>
			<img src="<?php echo esc_url(WPG_LLMSTXT_URL . 'assets/images/llms-text-logo-gen.png'); ?>"
				alt="<?php esc_attr_e('WPGeared LLMs.txt Generator', 'wpgeared-llms-txt-generator'); ?>"
				style="height: 40px; vertical-align: middle; margin-right: 10px;">
			<?php esc_html_e('WPGeared LLMs.txt Generator', 'wpgeared-llms-txt-generator'); ?>
		</h1>
		<div class="wpg_llmstxt-header-actions">
			<form method="post" style="display: inline-block;">
				<?php wp_nonce_field('wpg_llmstxt_regenerate'); ?>
				<input type="hidden" name="wpg_llmstxt_action" value="regenerate">
				<?php submit_button(__('Regenerate File', 'wpgeared-llms-txt-generator'), 'primary', 'regenerate', false); ?>
			</form>

			<form method="post" style="display: inline-block;">
				<?php wp_nonce_field('wpg_llmstxt_clear_cache'); ?>
				<input type="hidden" name="wpg_llmstxt_action" value="clear_cache">
				<?php submit_button(__('Clear Cache', 'wpgeared-llms-txt-generator'), 'secondary', 'clear_cache', false); ?>
			</form>
		</div>
	</div>

	<?php settings_errors('wpg_llmstxt_messages'); ?>

	<div class="wpg_llmstxt-container">
		<!-- Main Content -->
		<div class="wpg_llmstxt-main">
			<form action="options.php" method="post">
				<?php
				settings_fields('wpg_llmstxt_settings');
				?>

				<!-- Tabs Navigation -->
				<nav class="wpg_llmstxt-tabs-nav">
					<a href="#tab-general"
						class="wpg_llmstxt-tab-link active"><?php esc_html_e('General', 'wpgeared-llms-txt-generator'); ?></a>
					<a href="#tab-content"
						class="wpg_llmstxt-tab-link"><?php esc_html_e('Content & Content Types', 'wpgeared-llms-txt-generator'); ?></a>
					<a href="#tab-crawlers"
						class="wpg_llmstxt-tab-link"><?php esc_html_e('Crawlers & Stats', 'wpgeared-llms-txt-generator'); ?></a>
					<a href="#tab-advanced"
						class="wpg_llmstxt-tab-link"><?php esc_html_e('Advanced & Cache', 'wpgeared-llms-txt-generator'); ?></a>
					<a href="#tab-preview"
						class="wpg_llmstxt-tab-link"><?php esc_html_e('Preview', 'wpgeared-llms-txt-generator'); ?></a>
				</nav>

				<!-- Tab: General -->
				<div id="tab-general" class="wpg_llmstxt-tab-content active">
					<p class="description">
						<?php esc_html_e('Basic configuration for your LLMs.txt file.', 'wpgeared-llms-txt-generator'); ?>
					</p>

					<table class="wpg_llmstxt-form-table">
						<tr>
							<th><?php esc_html_e('Enable Plugin', 'wpgeared-llms-txt-generator'); ?></th>
							<td>
								<?php
								$wpg_llmstxt_enabled = get_option('wpg_llmstxt_enabled', 1);
								?>
								<label class="wpg_llmstxt-toggle">
									<input type="checkbox" name="wpg_llmstxt_enabled" value="1" <?php checked($wpg_llmstxt_enabled, 1); ?>>
									<span class="wpg_llmstxt-slider"></span>
								</label>
								<p class="description">
									<?php esc_html_e('Turn on to generate and serve the llms.txt file.', 'wpgeared-llms-txt-generator'); ?>
								</p>
							</td>
						</tr>
						<tr>
							<th><?php esc_html_e('Site Description', 'wpgeared-llms-txt-generator'); ?></th>
							<td>
								<?php
								$wpg_llmstxt_desc = get_option('wpg_llmstxt_site_description', '');
								?>
								<textarea name="wpg_llmstxt_site_description" rows="5"
									class="large-text code"><?php echo esc_textarea($wpg_llmstxt_desc); ?></textarea>
								<p class="description">
									<?php esc_html_e('Provide a concise description of your website for AI models. If empty, the site tagline will be used.', 'wpgeared-llms-txt-generator'); ?>
								</p>
							</td>
						</tr>
					</table>
				</div>

				<!-- Tab: Content -->
				<div id="tab-content" class="wpg_llmstxt-tab-content">
					<p class="description">
						<?php esc_html_e('Control what content is included in your LLMs.txt file.', 'wpgeared-llms-txt-generator'); ?>
					</p>

					<table class="wpg_llmstxt-form-table">
						<tr>
							<th><?php esc_html_e('Post Types', 'wpgeared-llms-txt-generator'); ?></th>
							<td>
								<?php $this->post_types_field_callback(); ?>
							</td>
						</tr>
						<tr>
							<th><?php esc_html_e('Taxonomies', 'wpgeared-llms-txt-generator'); ?></th>
							<td>
								<div class="wpg_llmstxt-grid">
									<label class="wpg_llmstxt-checkbox-label">
										<input type="checkbox" name="wpg_llmstxt_include_categories" value="1"
											<?php checked(get_option('wpg_llmstxt_include_categories', 1), 1); ?>>
										<?php esc_html_e('Include Categories', 'wpgeared-llms-txt-generator'); ?>
									</label>
									<label class="wpg_llmstxt-checkbox-label">
										<input type="checkbox" name="wpg_llmstxt_include_tags" value="1" <?php checked(get_option('wpg_llmstxt_include_tags', 1), 1); ?>>
										<?php esc_html_e('Include Tags', 'wpgeared-llms-txt-generator'); ?>
									</label>
								</div>
							</td>
						</tr>
						<tr>
							<th><?php esc_html_e('Exclusions', 'wpgeared-llms-txt-generator'); ?></th>
							<td>
								<input type="text" name="wpg_llmstxt_excluded_ids"
									value="<?php echo esc_attr(implode(', ', get_option('wpg_llmstxt_excluded_ids', array()))); ?>"
									class="large-text">
								<p class="description">
									<?php esc_html_e('Comma-separated list of Post IDs to exclude (e.g. 10, 25, 103).', 'wpgeared-llms-txt-generator'); ?>
								</p>
							</td>
						</tr>
					</table>
				</div>

				<!-- Tab: Crawlers -->
				<div id="tab-crawlers" class="wpg_llmstxt-tab-content">
					<p class="description">
						<?php esc_html_e('Monitor AI crawler activity on your site.', 'wpgeared-llms-txt-generator'); ?>
					</p>

					<table class="wpg_llmstxt-form-table">
						<tr>
							<th><?php esc_html_e('Crawler Detection', 'wpgeared-llms-txt-generator'); ?></th>
							<td>
								<label class="wpg_llmstxt-toggle">
									<input type="checkbox" name="wpg_llmstxt_crawler_detection" value="1" <?php checked(get_option('wpg_llmstxt_crawler_detection', 1), 1); ?>>
									<span class="wpg_llmstxt-slider"></span>
								</label>
								<p class="description">
									<?php esc_html_e('Log visits from known AI bots like GPTBot, ClaudeBot, etc.', 'wpgeared-llms-txt-generator'); ?>
								</p>
							</td>
						</tr>
					</table>

					<?php if (get_option('wpg_llmstxt_crawler_detection', 1)): ?>
						<div class="wpg_llmstxt-card" style="margin-top: 20px;">
							<h3><?php esc_html_e('Traffic Overview (Last 30 Days)', 'wpgeared-llms-txt-generator'); ?></h3>

							<div
								style="display: flex; gap: 40px; margin-bottom: 20px; border-bottom: 1px solid #eee; padding-bottom: 20px;">
								<div>
									<div style="font-size: 24px; font-weight: bold; color: var(--wpg_llmstxt-primary);">
										<?php echo esc_html(number_format_i18n($wpg_llmstxt_stats['total'])); ?>
									</div>
									<div class="description"><?php esc_html_e('Total Visits', 'wpgeared-llms-txt-generator'); ?>
									</div>
								</div>
								<div>
									<div style="font-size: 24px; font-weight: bold;">
										<?php echo count($wpg_llmstxt_stats['by_crawler']); ?>
									</div>
									<div class="description"><?php esc_html_e('Unique Bots', 'wpgeared-llms-txt-generator'); ?>
									</div>
								</div>
							</div>

							<?php if (!empty($wpg_llmstxt_stats['by_crawler'])): ?>
								<h4><?php esc_html_e('Top Bots', 'wpgeared-llms-txt-generator'); ?></h4>
								<div class="wpg_llmstxt-grid">
									<?php foreach ($wpg_llmstxt_stats['by_crawler'] as $wpg_llmstxt_crawler): ?>
										<div class="wpg_llmstxt-stat-item">
											<span><?php echo esc_html($wpg_llmstxt_crawler['crawler_name']); ?></span>
											<span
												class="wpg_llmstxt-stat-value"><?php echo esc_html(number_format_i18n($wpg_llmstxt_crawler['count'])); ?></span>
										</div>
									<?php endforeach; ?>
								</div>
							<?php endif; ?>
						</div>
					<?php endif; ?>
				</div>

				<!-- Tab: Advanced -->
				<div id="tab-advanced" class="wpg_llmstxt-tab-content">
					<p class="description">
						<?php esc_html_e('Fine-tune performance and caching.', 'wpgeared-llms-txt-generator'); ?>
					</p>

					<table class="wpg_llmstxt-form-table">
						<tr>
							<th><?php esc_html_e('Cache Duration', 'wpgeared-llms-txt-generator'); ?></th>
							<td>
								<input type="number" name="wpg_llmstxt_cache_duration"
									value="<?php echo esc_attr(get_option('wpg_llmstxt_cache_duration', 24)); ?>"
									min="1" max="168" class="small-text">
								<span
									class="description"><?php esc_html_e('Hours', 'wpgeared-llms-txt-generator'); ?></span>
								<p class="description">
									<?php esc_html_e('How long to keep the generated file in cache. Longer is better for performance.', 'wpgeared-llms-txt-generator'); ?>
								</p>
							</td>
						</tr>
						<tr>
							<th><?php esc_html_e('Cache Status', 'wpgeared-llms-txt-generator'); ?></th>
							<td>
								<?php if ($wpg_llmstxt_cache_stats['exists']): ?>
									<span
										class="wpg_llmstxt-badge success"><?php esc_html_e('Active', 'wpgeared-llms-txt-generator'); ?></span>
									<p class="description">
										<?php
										/* translators: %s: Expiration date and time */
										printf(esc_html__('Expires on: %s', 'wpgeared-llms-txt-generator'), esc_html(date_i18n(get_option('date_format') . ' ' . get_option('time_format'), $wpg_llmstxt_cache_stats['expires'])));
										?>
									</p>
								<?php else: ?>
									<span
										class="wpg_llmstxt-badge warning"><?php esc_html_e('Not Cached', 'wpgeared-llms-txt-generator'); ?></span>
								<?php endif; ?>
							</td>
						</tr>
					</table>
				</div>

				<!-- Tab: Preview -->
				<div id="tab-preview" class="wpg_llmstxt-tab-content">
					<div class="wpg_llmstxt-preview-box">
						<div class="wpg_llmstxt-preview-header">
							<span><?php echo esc_url(home_url('/llms.txt')); ?></span>
							<a href="<?php echo esc_url(home_url('/llms.txt')); ?>" target="_blank"
								style="color: #fff; text-decoration: none;">
								<span class="dashicons dashicons-external"></span>
								<?php esc_html_e('Open File', 'wpgeared-llms-txt-generator'); ?>
							</a>
						</div>
						<textarea readonly
							class="wpg_llmstxt-preview-content"><?php echo esc_textarea($wpg_llmstxt_generator->generate()); ?></textarea>
					</div>
				</div>

				<div style="margin-top: 20px;">
					<?php submit_button(__('Save Changes', 'wpgeared-llms-txt-generator'), 'primary large'); ?>
				</div>
			</form>
		</div>

		<!-- Sidebar -->
		<div class="wpg_llmstxt-sidebar">
			<div class="wpg_llmstxt-card">
				<h2><?php esc_html_e('Plugin Status', 'wpgeared-llms-txt-generator'); ?></h2>
				<div class="wpg_llmstxt-stat-item">
					<span><?php esc_html_e('Version', 'wpgeared-llms-txt-generator'); ?></span>
					<strong><?php echo esc_html(WPG_LLMSTXT_VERSION); ?></strong>
				</div>
				<div class="wpg_llmstxt-stat-item">
					<span><?php esc_html_e('Status', 'wpgeared-llms-txt-generator'); ?></span>
					<?php if (get_option('wpg_llmstxt_enabled', 1)): ?>
						<span class="wpg_llmstxt-badge success"><?php esc_html_e('Active', 'wpgeared-llms-txt-generator'); ?></span>
					<?php else: ?>
						<span class="wpg_llmstxt-badge danger"><?php esc_html_e('Inactive', 'wpgeared-llms-txt-generator'); ?></span>
					<?php endif; ?>
				</div>
			</div>

			<?php if (!empty($wpg_llmstxt_active_seo)): ?>
				<div class="wpg_llmstxt-card">
					<h2><?php esc_html_e('Integrations', 'wpgeared-llms-txt-generator'); ?></h2>
					<p class="description" style="margin-bottom: 10px;">
						<?php esc_html_e('Detected SEO plugins:', 'wpgeared-llms-txt-generator'); ?>
					</p>
					<?php foreach ($wpg_llmstxt_active_seo as $plugin): ?>
						<div class="wpg_llmstxt-stat-item">
							<span><?php echo esc_html($plugin); ?></span>
							<span class="dashicons dashicons-yes" style="color: var(--wpg_llmstxt-success);"></span>
						</div>
					<?php endforeach; ?>
				</div>
			<?php endif; ?>

			<div class="wpg_llmstxt-card">
				<h2><?php esc_html_e('Need Help?', 'wpgeared-llms-txt-generator'); ?></h2>
				<p><?php esc_html_e('LLMs.txt helps AI agents understand your website structure.', 'wpgeared-llms-txt-generator'); ?>
				</p>
				<p>
					<a href="https://wordpress.org/plugins/wpgeared-llms-txt-generator"
						target="_blank"><?php esc_html_e('View Documentation', 'wpgeared-llms-txt-generator'); ?> &rarr;</a>
				</p>
			</div>
		</div>
	</div>
</div>