/**
 * Admin JavaScript for LLMs.txt Manager
 * Professional Tab Handling & UI Interactions
 *
 * @package WPG_LLMsTxt_Manager
 */

(function ($) {
	'use strict';

	$(document).ready(function () {
		// Tab Switching Logic
		$('.wpg_llmstxt-tab-link').on('click', function (e) {
			e.preventDefault();

			// Remove active class from all tabs
			$('.wpg_llmstxt-tab-link').removeClass('active');
			$('.wpg_llmstxt-tab-content').removeClass('active');

			// Add active class to clicked tab
			$(this).addClass('active');

			// Show corresponding content
			var target = $(this).attr('href');
			$(target).addClass('active');

			// Store active tab in localStorage
			localStorage.setItem('wpg_llmstxt_active_tab', target);
		});

		// Restore active tab on page load
		var activeTab = localStorage.getItem('wpg_llmstxt_active_tab');
		if (activeTab && $(activeTab).length) {
			$('.wpg_llmstxt-tab-link[href="' + activeTab + '"]').click();
		}

		// Handle cache clear confirmation
		$('form[action*="clear_cache"]').on('submit', function (e) {
			if (!confirm('Are you sure you want to clear the cache?')) {
				e.preventDefault();
				return false;
			}
		});

		// Handle regenerate confirmation
		$('form[action*="regenerate"]').on('submit', function (e) {
			if (!confirm('Are you sure you want to regenerate the LLMs.txt file?')) {
				e.preventDefault();
				return false;
			}
		});

		// Toggle visual feedback
		$('.wpg_llmstxt-toggle input').on('change', function () {
			var $parent = $(this).closest('.wpg_llmstxt-toggle');
			if ($(this).is(':checked')) {
				$parent.find('.wpg_llmstxt-slider').css('background-color', 'var(--wpg_llmstxt-primary)');
			} else {
				$parent.find('.wpg_llmstxt-slider').css('background-color', '#ccc');
			}
		});
	});

})(jQuery);
