<?php
// don't load directly 
if ( !defined('ABSPATH') ) {
	header( 'Status: 403 Forbidden' );
	header( 'HTTP/1.1 403 Forbidden' );
	exit();
}
//error_reporting( E_CORE_ERROR | E_CORE_WARNING | E_COMPILE_ERROR | E_ERROR | E_WARNING | E_PARSE | E_USER_ERROR | E_USER_WARNING | E_RECOVERABLE_ERROR );

$cached = get_transient( '_etruel_wpem_reviews_data' );
// Always return cached transients if exists.
if ( !empty( $cached ) ) {
	echo $cached;
	return;
}

$url = 'https://wordpress.org/support/plugin/wpematico/reviews/?filter=5';
//$cookie_jar = @tempnam('./tmp','cookie');
$args = array(
	'user-agent'=> "Mozilla/5.0 (Windows; U; Windows NT 5.1; rv:1.7.3) Gecko/20041001 Firefox/0.10.1",
	// 'cookies'   => array($cookie_jar)
);

$html = WPeMatico_functions::wpematico_get_contents($url, $args);
//print_r( $html,1 ); //exit;

// remove the cookie jar
// unlink($cookie_jar) /*or die("Can't unlink $cookie_jar")*/;

if (!$html) {
	echo '<div id="reviews">'.  __('Can\t connect to Wordpress Site', 'wpematico' ).'</div>';
	return false;
}

// EMPIEZA STRPOS
$tiempo = microtime(true);
$reviews = substr($html, strpos($html, '<li class="bbp-body">') ); //start
$reviews = substr($reviews, 0, strpos($reviews, '<li class="bbp-footer">')  );  //end
$reviews = preg_replace('/<li class="bbp-topic-voice-count">(.*?)<\/li>/i', ' ', $reviews);
$reviews = preg_replace('/<li class="bbp-topic-reply-count">(.*?)<\/li>/i', ' ', $reviews);
$reviews = preg_replace('/<li class="bbp-topic-freshness">(.*?)<\/li>/is', ' ', $reviews);
//$reviews = str_replace('<li class="bbp-body">', '<div class="bbp-body">', $reviews );
$reviews = str_replace('Started by', 'By ', $reviews );
$reviews = str_replace('href=', 'target="_Blank" href=', $reviews );
//$reviews = str_replace('<a ', '<a target="_Blank" ', $reviews );
//echo ' '. (string)(microtime(true)-$tiempo) . ' milisec STRPOS<br>';
//<div class="reviews-comment-link">

ob_start();

?><style type="text/css">
.clear {clear: both;}
.hidden { display: none; }

#reviews .bbp-body{
	list-style: none;
}
.odd {
    background: #eee;
}	
.even {
    background: aliceblue;
}
.type-topic.hentry {
    padding: 4px;
}	
.bbp-topic-meta {
    margin: 0;
}
.wporg-ratings {
    float: right;
    text-align: right;
}

@font-face {
	font-family: "dashicons";
    src: url(data:application/font-woff;charset=utf-8;base64,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) format('woff'),
		url(../fonts/dashicons.ttf) format("truetype"),
		url(../fonts/dashicons.svg#dashicons) format("svg");
	font-weight: normal;
	font-style: normal;
}
</style>
<ul id="reviews">
	<?php echo ($reviews); ?>
</ul>
<?php

$contents = ob_get_contents();
ob_end_clean();

// Save reviews on cache once per day
set_transient( '_etruel_wpem_reviews_data', $contents, DAY_IN_SECONDS ); 

echo $contents;