<?php
/**
 * Image service
 *
 * @author    Wpayme <hi@wpayme.com>
 * @copyright 2024-2025 Wpayme
 * @license   GPL-2.0-or-later
 * @package   Wpayme\IDealIssuers
 */

namespace Wpayme\WpPayLogos;

/**
 * Image service class
 */
final class ImageService {
	/**
	 * Directory.
	 * 
	 * @var string
	 */
	private $directory;

	/**
	 * Construct image service.
	 */
	public function __construct() {
		$this->directory = \realpath( __DIR__ . '/../dist/' );
	}

	/**
	 * Get path.
	 * 
	 * @param string $path Path.
	 * @return string
	 */
	public function get_path( string $path ): string {
		return $this->directory . DIRECTORY_SEPARATOR . $path;
	}
}
