<?php
/**
 * Uninstall
 *
 * @author    Wpayme <hi@wpayme.com>
 * @copyright 2024-2025 Wpayme
 * @license   GPL-3.0-or-later
 * @package   Wpayme\WordPress\Pay
 */

if ( ! defined( 'WP_UNINSTALL_PLUGIN' ) ) {
	exit;
}

global $wpdb;

if ( '1' !== get_option( 'wpayme_pay_uninstall_clear_data', false ) ) {
	return;
}

// phpcs:disable WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.DirectDatabaseQuery.SchemaChange

// Delete tables.
$wpdb->query( "DROP TABLE IF EXISTS {$wpdb->prefix}wpayme_configurations" );
$wpdb->query( "DROP TABLE IF EXISTS {$wpdb->prefix}wpayme_payments" );
$wpdb->query( "DROP TABLE IF EXISTS {$wpdb->prefix}rg_ideal_feeds" );

// Delete posts.
$wpdb->query( "DELETE FROM {$wpdb->prefix}posts WHERE post_type = 'wpayme_gateway';" );
$wpdb->query( "DELETE FROM {$wpdb->prefix}posts WHERE post_type = 'wpayme_payment';" );
$wpdb->query( "DELETE FROM {$wpdb->prefix}posts WHERE post_type = 'wpayme_pay_gf';" );

$wpdb->query( "DELETE FROM {$wpdb->prefix}postmeta WHERE post_id NOT IN ( SELECT ID FROM {$wpdb->prefix}posts );" );

// phpcs:enable WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.DirectDatabaseQuery.SchemaChange

// Delete general options.
delete_option( 'wpayme_pay_version' );
delete_option( 'wpayme_pay_db_version' );

/**
 * Delete extension options.
 */

// Event Espresso.
delete_option( 'wpayme_pay_ideal_event_espreso_config_id' );

// Gravity Forms.
// There are options for Gravity Forms.

// Jigoshop.
// Set default Jigoshop variables, load them form the WordPress options.
delete_option( 'wpayme_pay_ideal_jigoshop_enabled' );
delete_option( 'wpayme_pay_ideal_jigoshop_title' );
delete_option( 'wpayme_pay_ideal_jigoshop_description' );
delete_option( 'wpayme_pay_ideal_jigoshop_config_id' );

// Membership.
delete_option( 'wpayme_pay_ideal_membership_config_id' );

// s2Member®.
delete_option( 'wpayme_pay_ideal_s2member_config_id' );

// Shopp.
// Shopp options are stored in the Shopp meta table, we don't touch this.

// WooCommerce.
delete_option( 'woocommerce_wpayme_pay_ideal_settings' );

// WP e-Commerce.
delete_option( 'wpayme_pay_ideal_wpsc_config_id' );

/**
 * Delete legacy options.
 */

// General.
delete_option( 'wpayme_version' );
delete_option( 'wpayme_key' );
delete_option( 'gf_ideal_version' );

// Event Espresso.
delete_option( 'wpayme_event_espresso_configuration_id' );

// Jigoshop.
delete_option( 'jigoshop_wpayme_enabled' );
delete_option( 'jigoshop_wpayme_title' );
delete_option( 'jigoshop_wpayme_description' );
delete_option( 'jigoshop_wpayme_configuration_id' );

// Membership.
delete_option( 'wpayme_membership_enabled' );
delete_option( 'wpayme_membership_chosen_configuration' );

// s2Member®.
delete_option( 'wpayme_s2member_enabled' );
delete_option( 'wpayme_s2member_chosen_configuration' );

// WooCommerce.
delete_option( 'woocommerce_wpayme_settings' );

// WP e-Commerce.
delete_option( 'wpayme_wpsc_configuration_id' );
