<?php
/**
 * Plugin Name: WPayme Admin Reports
 * Plugin URI: https://www.wpayme.com/plugins/wpayme-pay-admin-reports/
 * Description: This plugin adds simple reporting functionality in the WordPress admin dashboard for the WPayme plugin.
 *
 * Version: 1.0.0
 * Requires at least: 5.9
 * Requires PHP: 8.1
 *
 * Author: Wpayme
 * Author URI: https://www.wpayme.com/
 *
 * Text Domain: wpayme-ideal
 * Domain Path: /languages/
 *
 * License: GPL-2.0-or-later
 *
 * GitHub URI: https://github.com/wpayme/wpayme-pay-admin-reports
 *
 * @author    Wpayme <hi@wpayme.com>
 * @copyright 2005-2023 Wpayme
 * @license   GPL-3.0-or-later
 * @package   Wpayme\WpaymePayAdminReports
 */

if ( ! \defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Autoload.
 */
require_once __DIR__ . '/vendor/autoload_packages.php';

/**
 * Bootstrap.
 */
\Wpayme\WordPress\Pay\Plugin::instance(
	[
		'file'             => __FILE__,
		'action_scheduler' => __DIR__ . '/packages/woocommerce/action-scheduler/action-scheduler.php',
	]
);

\Wpayme\WpaymePayAdminReports\Plugin::instance()->setup();
