<?php
/**
 * Page Reports
 *
 * @author Wpayme <hi@wpayme.com>
 * @copyright 2005-2023 Wpayme
 * @license GPL-3.0-or-later
 * @package Wpayme\WordPress\Pay
 * @var \Wpayme\WordPress\Pay\Admin\AdminReports $admin_reports Admin reports.
 */

use Wpayme\WordPress\Money\Money;
use Wpayme\WordPress\Pay\Util;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

?>
<div class="wrap">
	<h1 class="wp-heading-inline"><?php echo esc_html( get_admin_page_title() ); ?></h1>

	<hr class="wp-header-end">

	<div id="poststuff">
		<div class="postbox">
			<div class="wpayme-pay-chart-filter">

			</div>

			<div class="inside wpayme-pay-chart-with-sidebar">
				<div class="wpayme-pay-chart-sidebar">
					<ul class="wpayme-pay-chart-legend">

						<?php // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound ?>
						<?php foreach ( $admin_reports->get_reports() as $i => $serie ) : ?>

                            <?php // phpcs:disable WordPress.NamingConventions.ValidVariableName.UsedPropertyNotSnakeCase -- Flot data object. ?>

							<li class="<?php echo esc_attr( $serie->class ); ?>" data-wpayme-pay-highlight-serie="<?php echo esc_attr( $i ); ?>">
								<?php

								echo '<strong>';

								// phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
								$legend_value = \property_exists( $serie, 'legendValue' ) ? $serie->legendValue : '';

								if ( isset( $serie->tooltipFormatter ) && 'money' === $serie->tooltipFormatter ) {
									// phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
									$money = new Money( $legend_value, 'EUR' );

									echo esc_html( $money->format_i18n() );
								} else {
									echo esc_html( $legend_value );
								}

								echo '</strong>';

								echo esc_html( $serie->label );

								?>
							</li>

							<?php // phpcs:enable WordPress.NamingConventions.ValidVariableName.UsedPropertyNotSnakeCase -- Flot data object. ?>

						<?php endforeach; ?>

					</ul>
				</div>

				<div id="chart1" style="height: 500px; width: 100%;"></div>
			</div>
		</div>
	</div>
</div>
