<?php
/**
 * Plugin Name: WPayme Forms
 * Description: Payment forms for the Wpayme payment platform.
 * Version: 1.0.1
 * Author: Wpayme
 * Author URI: https://www.wpayme.com
 * License: GPL-3.0-or-later
 *
 * @author    Wpayme <hi@wpayme.com>
 * @copyright 2024-2025 Wpayme
 * @license   GPL-3.0-or-later
 * @package   Wpayme\WordPress\Pay\Forms
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * WPayme Forms bootstrap file
 * This ensures all classes are loaded in the correct order
 */

// Load required files in the correct order
( function () {
	$src_dir = __DIR__ . '/src';

	// Core files needed before classes can be instantiated
	require_once $src_dir . '/CouponPostType.php';
	require_once $src_dir . '/FormPostType.php';
	require_once $src_dir . '/CouponAdmin.php';
	require_once $src_dir . '/Admin.php';
	require_once $src_dir . '/FormProcessor.php';
	require_once $src_dir . '/FormScripts.php';
	require_once $src_dir . '/FormsSource.php';
	require_once $src_dir . '/FormShortcode.php';
	require_once $src_dir . '/EmailNotifications.php';
	require_once $src_dir . '/Plugin.php';
} )();

// Integration is loaded separately in the main plugin 