<?php
// phpcs:disable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound

/**
 * Meta box email settings view.
 *
 * @author    Wpayme <hi@wpayme.com>
 * @copyright 2024-2025 Wpayme
 * @license   GPL-3.0-or-later
 * @package   Wpayme\WordPress\Pay\Forms
 */

use Wpayme\WordPress\Pay\Admin\AdminSettings;

if (!defined('ABSPATH')) {
    exit;
}

// Fields from AdminSettings
$admin_settings = new AdminSettings();

// Get saved values
$enable_buyer_email = get_post_meta($post->ID, '_wpayme_payment_form_enable_buyer_email', true);
$enable_seller_email = get_post_meta($post->ID, '_wpayme_payment_form_enable_seller_email', true);
$enable_failure_email = get_post_meta($post->ID, '_wpayme_payment_form_enable_failure_email', true);
$enable_buyer_failure_email = get_post_meta($post->ID, '_wpayme_payment_form_enable_buyer_failure_email', true);
$enable_rate_limit_email = get_post_meta($post->ID, '_wpayme_payment_form_enable_rate_limit_email', true);

$email_content_type = get_post_meta($post->ID, '_wpayme_payment_form_email_content_type', true);
if (empty($email_content_type)) {
    $email_content_type = 'text/html';
}

?>

<?php
$css = "/* Make sure the WYSIWYG editors display properly in hidden tabs */
.wpayme-tab:not(.active) .wp-editor-wrap {
    display: none;
}
.wpayme-tab.active .wp-editor-wrap {
    display: block;
}
/* Add some spacing between the editor and the shortcodes hint */
.wpayme-shortcodes-hint {
    margin-top: 15px;
}
/* Make the editor width match the container */
.wpayme-wysiwyg-editor {
    width: 100%;
}";
wp_add_inline_style('wpayme-pay-admin', $css);

$script = "jQuery(document).ready(function($) {
    // Fix for WYSIWYG editors in tabs - reinitialize them when tab is clicked
    $('.wpayme-tabs-nav a').on('click', function() {
        var tabId = $(this).attr('href');
        
        // Wait a bit for the tab to become visible
        setTimeout(function() {
            // For each editor in the active tab
            $(tabId).find('.wp-editor-area').each(function() {
                var editorId = $(this).attr('id');
                if (typeof tinymce !== 'undefined' && tinymce.get(editorId)) {
                    tinymce.execCommand('mceRemoveEditor', true, editorId);
                    tinymce.execCommand('mceAddEditor', true, editorId);
                }
            });
        }, 10);
    });
});";
wp_add_inline_script('wpayme-pay-admin', $script);
?>

<div class="wpayme-tabs">
    <ul class="wpayme-tabs-nav">
        <li class="active"><a href="#buyer-email-tab"><?php esc_html_e('Buyer Emails', 'wpayme'); ?></a></li>
        <li><a href="#seller-email-tab"><?php esc_html_e('Seller Emails', 'wpayme'); ?></a></li>
        <li><a href="#failure-email-tab"><?php esc_html_e('Failure Notifications', 'wpayme'); ?></a></li>
        <li><a href="#rate-limit-tab"><?php esc_html_e('Rate Limiting', 'wpayme'); ?></a></li>
        <li><a href="#email-settings-tab"><?php esc_html_e('General Settings', 'wpayme'); ?></a></li>
    </ul>

    <div class="wpayme-tabs-content">
        <!-- Buyer Email Tab -->
        <div id="buyer-email-tab" class="wpayme-tab active">
            <table class="form-table">
                <tr>
                    <th scope="row"><?php esc_html_e('Enable Buyer Notifications', 'wpayme'); ?></th>
                    <td>
                        <fieldset>
                            <legend class="screen-reader-text"><span><?php esc_html_e('Enable Buyer Notifications', 'wpayme'); ?></span></legend>
                            <label for="wpayme_payment_form_enable_buyer_email">
                                <input name="_wpayme_payment_form_enable_buyer_email" type="checkbox" id="wpayme_payment_form_enable_buyer_email" value="yes" <?php checked($enable_buyer_email, 'yes'); ?>>
                                <?php esc_html_e('Send email notification to buyer on successful payment', 'wpayme'); ?>
                            </label>
                        </fieldset>
                    </td>
                </tr>
                
                <tr>
                    <th scope="row"><?php esc_html_e('Email Subject', 'wpayme'); ?></th>
                    <td>
                        <input name="_wpayme_payment_form_buyer_email_subject" type="text" id="wpayme_payment_form_buyer_email_subject" value="<?php echo esc_attr(get_post_meta($post->ID, '_wpayme_payment_form_buyer_email_subject', true)); ?>" class="large-text">
                        <p class="description"><?php esc_html_e('Subject line for buyer confirmation emails. Default: "Payment Confirmation - {site_name}"', 'wpayme'); ?></p>
                    </td>
                </tr>
                
                <tr>
                    <th scope="row"><?php esc_html_e('Email Content', 'wpayme'); ?></th>
                    <td>
                        <?php
                        // Use WordPress WYSIWYG editor
                        $buyer_email_body = get_post_meta($post->ID, '_wpayme_payment_form_buyer_email_body', true);
                        wp_editor(
                            $buyer_email_body,
                            'wpayme_payment_form_buyer_email_body',
                            array(
                                'textarea_name' => '_wpayme_payment_form_buyer_email_body',
                                'media_buttons' => true,
                                'textarea_rows' => 10,
                                'editor_class'  => 'wpayme-wysiwyg-editor',
                                'teeny' => false,
                                'quicktags' => true,
                            )
                        );
                        
                        $admin_settings->email_shortcodes_hint([
                            'tags' => [
                                '{site_name}' => __('The name of your website', 'wpayme'),
                                '{site_url}' => __('Your website URL', 'wpayme'),
                                '{payment_date}' => __('The date of the payment', 'wpayme'),
                                '{payment_id}' => __('The unique payment ID', 'wpayme'),
                                '{transaction_id}' => __('The payment transaction ID', 'wpayme'),
                                '{payment_amount}' => __('The payment amount', 'wpayme'),
                                '{payment_method}' => __('The payment method used', 'wpayme'),
                                '{customer_first_name}' => __('Customer\'s first name', 'wpayme'),
                                '{customer_last_name}' => __('Customer\'s last name', 'wpayme'),
                                '{customer_full_name}' => __('Customer\'s full name', 'wpayme'),
                                '{customer_email}' => __('Customer\'s email address', 'wpayme'),
                                '{form_id}' => __('The payment form ID', 'wpayme'),
                                '{form_title}' => __('The payment form title', 'wpayme'),
                                '{order_id}' => __('The order ID', 'wpayme'),
                            ]
                        ]);
                        ?>
                    </td>
                </tr>
                
                <tr>
                    <th scope="row"><?php esc_html_e('Enable Failure Notifications', 'wpayme'); ?></th>
                    <td>
                        <fieldset>
                            <legend class="screen-reader-text"><span><?php esc_html_e('Enable Buyer Failure Notifications', 'wpayme'); ?></span></legend>
                            <label for="wpayme_payment_form_enable_buyer_failure_email">
                                <input name="_wpayme_payment_form_enable_buyer_failure_email" type="checkbox" id="wpayme_payment_form_enable_buyer_failure_email" value="yes" <?php checked($enable_buyer_failure_email, 'yes'); ?>>
                                <?php esc_html_e('Send email notification to buyer when payment fails', 'wpayme'); ?>
                            </label>
                        </fieldset>
                    </td>
                </tr>
                
                <tr>
                    <th scope="row"><?php esc_html_e('Failure Email Subject', 'wpayme'); ?></th>
                    <td>
                        <input name="_wpayme_payment_form_buyer_failure_subject" type="text" id="wpayme_payment_form_buyer_failure_subject" value="<?php echo esc_attr(get_post_meta($post->ID, '_wpayme_payment_form_buyer_failure_subject', true)); ?>" class="large-text">
                        <p class="description"><?php esc_html_e('Subject line for buyer failure emails. Default: "Payment Failed - {site_name}"', 'wpayme'); ?></p>
                    </td>
                </tr>
                
                <tr>
                    <th scope="row"><?php esc_html_e('Failure Email Content', 'wpayme'); ?></th>
                    <td>
                        <?php
                        // Use WordPress WYSIWYG editor for buyer failure email content
                        $buyer_failure_body = get_post_meta($post->ID, '_wpayme_payment_form_buyer_failure_body', true);
                        wp_editor(
                            $buyer_failure_body,
                            'wpayme_payment_form_buyer_failure_body',
                            array(
                                'textarea_name' => '_wpayme_payment_form_buyer_failure_body',
                                'media_buttons' => true,
                                'textarea_rows' => 10,
                                'editor_class'  => 'wpayme-wysiwyg-editor',
                                'teeny' => false,
                                'quicktags' => true,
                            )
                        );
                        ?>
                    </td>
                </tr>
            </table>
        </div>

        <!-- Seller Email Tab -->
        <div id="seller-email-tab" class="wpayme-tab">
            <table class="form-table">
                <tr>
                    <th scope="row"><?php esc_html_e('Enable Seller Notifications', 'wpayme'); ?></th>
                    <td>
                        <fieldset>
                            <legend class="screen-reader-text"><span><?php esc_html_e('Enable Seller Notifications', 'wpayme'); ?></span></legend>
                            <label for="wpayme_payment_form_enable_seller_email">
                                <input name="_wpayme_payment_form_enable_seller_email" type="checkbox" id="wpayme_payment_form_enable_seller_email" value="yes" <?php checked($enable_seller_email, 'yes'); ?>>
                                <?php esc_html_e('Send email notification to seller when payment is successful', 'wpayme'); ?>
                            </label>
                        </fieldset>
                    </td>
                </tr>
                
                <tr>
                    <th scope="row"><?php esc_html_e('Seller Email', 'wpayme'); ?></th>
                    <td>
                        <input name="_wpayme_payment_form_seller_email" type="email" id="wpayme_payment_form_seller_email" value="<?php echo esc_attr(get_post_meta($post->ID, '_wpayme_payment_form_seller_email', true)); ?>" class="regular-text">
                        <p class="description"><?php esc_html_e('Email address to receive seller notifications. If empty, site admin email will be used.', 'wpayme'); ?></p>
                    </td>
                </tr>
                
                <tr>
                    <th scope="row"><?php esc_html_e('Email Subject', 'wpayme'); ?></th>
                    <td>
                        <input name="_wpayme_payment_form_seller_email_subject" type="text" id="wpayme_payment_form_seller_email_subject" value="<?php echo esc_attr(get_post_meta($post->ID, '_wpayme_payment_form_seller_email_subject', true)); ?>" class="large-text">
                        <p class="description"><?php esc_html_e('Subject line for seller notification emails. Default: "New Payment Received - {site_name}"', 'wpayme'); ?></p>
                    </td>
                </tr>
                
                <tr>
                    <th scope="row"><?php esc_html_e('Email Content', 'wpayme'); ?></th>
                    <td>
                        <?php
                        // Use WordPress WYSIWYG editor for seller email content
                        $seller_email_body = get_post_meta($post->ID, '_wpayme_payment_form_seller_email_body', true);
                        wp_editor(
                            $seller_email_body,
                            'wpayme_payment_form_seller_email_body',
                            array(
                                'textarea_name' => '_wpayme_payment_form_seller_email_body',
                                'media_buttons' => true,
                                'textarea_rows' => 10,
                                'editor_class'  => 'wpayme-wysiwyg-editor',
                                'teeny' => false,
                                'quicktags' => true,
                            )
                        );
                        
                        $admin_settings->email_shortcodes_hint([
                            'tags' => [
                                '{site_name}' => __('The name of your website', 'wpayme'),
                                '{site_url}' => __('Your website URL', 'wpayme'),
                                '{payment_date}' => __('The date of the payment', 'wpayme'),
                                '{payment_id}' => __('The unique payment ID', 'wpayme'),
                                '{transaction_id}' => __('The payment transaction ID', 'wpayme'),
                                '{payment_amount}' => __('The payment amount', 'wpayme'),
                                '{payment_method}' => __('The payment method used', 'wpayme'),
                                '{customer_first_name}' => __('Customer\'s first name', 'wpayme'),
                                '{customer_last_name}' => __('Customer\'s last name', 'wpayme'),
                                '{customer_full_name}' => __('Customer\'s full name', 'wpayme'),
                                '{customer_email}' => __('Customer\'s email address', 'wpayme'),
                                '{form_id}' => __('The payment form ID', 'wpayme'),
                                '{form_title}' => __('The payment form title', 'wpayme'),
                                '{order_id}' => __('The order ID', 'wpayme'),
                            ]
                        ]);
                        ?>
                    </td>
                </tr>
            </table>
        </div>

        <!-- Failure Notifications Tab -->
        <div id="failure-email-tab" class="wpayme-tab">
            <table class="form-table">
                <tr>
                    <th scope="row"><?php esc_html_e('Enable Failure Notifications', 'wpayme'); ?></th>
                    <td>
                        <fieldset>
                            <legend class="screen-reader-text"><span><?php esc_html_e('Enable Failure Notifications', 'wpayme'); ?></span></legend>
                            <label for="wpayme_payment_form_enable_failure_email">
                                <input name="_wpayme_payment_form_enable_failure_email" type="checkbox" id="wpayme_payment_form_enable_failure_email" value="yes" <?php checked($enable_failure_email, 'yes'); ?>>
                                <?php esc_html_e('Send email notification to admin when payment fails', 'wpayme'); ?>
                            </label>
                        </fieldset>
                    </td>
                </tr>
                
                <tr>
                    <th scope="row"><?php esc_html_e('Failure Notification Email', 'wpayme'); ?></th>
                    <td>
                        <input name="_wpayme_payment_form_failure_email" type="email" id="wpayme_payment_form_failure_email" value="<?php echo esc_attr(get_post_meta($post->ID, '_wpayme_payment_form_failure_email', true)); ?>" class="regular-text">
                        <p class="description"><?php esc_html_e('Email address to receive failure notifications. If empty, site admin email will be used.', 'wpayme'); ?></p>
                    </td>
                </tr>
                
                <tr>
                    <th scope="row"><?php esc_html_e('Failure Email Subject', 'wpayme'); ?></th>
                    <td>
                        <input name="_wpayme_payment_form_failure_email_subject" type="text" id="wpayme_payment_form_failure_email_subject" value="<?php echo esc_attr(get_post_meta($post->ID, '_wpayme_payment_form_failure_email_subject', true)); ?>" class="large-text">
                        <p class="description"><?php esc_html_e('Subject line for failure notification emails. Default: "Payment Failed - {site_name}"', 'wpayme'); ?></p>
                    </td>
                </tr>
                
                <tr>
                    <th scope="row"><?php esc_html_e('Failure Email Content', 'wpayme'); ?></th>
                    <td>
                        <?php
                        // Use WordPress WYSIWYG editor for failure email content
                        $failure_email_body = get_post_meta($post->ID, '_wpayme_payment_form_failure_email_body', true);
                        wp_editor(
                            $failure_email_body,
                            'wpayme_payment_form_failure_email_body',
                            array(
                                'textarea_name' => '_wpayme_payment_form_failure_email_body',
                                'media_buttons' => true,
                                'textarea_rows' => 10,
                                'editor_class'  => 'wpayme-wysiwyg-editor',
                                'teeny' => false,
                                'quicktags' => true,
                            )
                        );
                        
                        $admin_settings->email_shortcodes_hint([
                            'tags' => [
                                '{site_name}' => __('The name of your website', 'wpayme'),
                                '{site_url}' => __('Your website URL', 'wpayme'),
                                '{payment_date}' => __('The date of the payment', 'wpayme'),
                                '{payment_id}' => __('The unique payment ID', 'wpayme'),
                                '{transaction_id}' => __('The payment transaction ID', 'wpayme'),
                                '{payment_amount}' => __('The payment amount', 'wpayme'),
                                '{payment_method}' => __('The payment method used', 'wpayme'),
                                '{customer_first_name}' => __('Customer\'s first name', 'wpayme'),
                                '{customer_last_name}' => __('Customer\'s last name', 'wpayme'),
                                '{customer_full_name}' => __('Customer\'s full name', 'wpayme'),
                                '{customer_email}' => __('Customer\'s email address', 'wpayme'),
                                '{form_id}' => __('The payment form ID', 'wpayme'),
                                '{form_title}' => __('The payment form title', 'wpayme'),
                                '{order_id}' => __('The order ID', 'wpayme'),
                            ]
                        ]);
                        ?>
                    </td>
                </tr>
            </table>
        </div>

        <!-- Rate Limit Tab -->
        <div id="rate-limit-tab" class="wpayme-tab">
            <table class="form-table">
                <tr>
                    <th scope="row"><?php esc_html_e('Enable Rate Limit Notifications', 'wpayme'); ?></th>
                    <td>
                        <fieldset>
                            <legend class="screen-reader-text"><span><?php esc_html_e('Enable Rate Limit Notifications', 'wpayme'); ?></span></legend>
                            <label for="wpayme_payment_form_enable_rate_limit_email">
                                <input name="_wpayme_payment_form_enable_rate_limit_email" type="checkbox" id="wpayme_payment_form_enable_rate_limit_email" value="yes" <?php checked($enable_rate_limit_email, 'yes'); ?>>
                                <?php esc_html_e('Send email notification when rate limit is reached', 'wpayme'); ?>
                            </label>
                        </fieldset>
                    </td>
                </tr>
                
                <tr>
                    <th scope="row"><?php esc_html_e('Rate Limit Notification Email', 'wpayme'); ?></th>
                    <td>
                        <input name="_wpayme_payment_form_rate_limit_email" type="email" id="wpayme_payment_form_rate_limit_email" value="<?php echo esc_attr(get_post_meta($post->ID, '_wpayme_payment_form_rate_limit_email', true)); ?>" class="regular-text">
                        <p class="description"><?php esc_html_e('Email address to receive rate limit notifications. If empty, site admin email will be used.', 'wpayme'); ?></p>
                    </td>
                </tr>
            </table>
        </div>

        <!-- General Settings Tab -->
        <div id="email-settings-tab" class="wpayme-tab">
            <table class="form-table">
                <tr>
                    <th scope="row"><?php esc_html_e('Email Format', 'wpayme'); ?></th>
                    <td>
                        <?php
                        $admin_settings->select_content_type([
                            'id' => '_wpayme_payment_form_email_content_type',
                            'name' => '_wpayme_payment_form_email_content_type',
                            'value' => $email_content_type,
                            'description' => __('Choose the content type for all emails sent by this form.', 'wpayme')
                        ]);
                        ?>
                    </td>
                </tr>
            </table>
        </div>
    </div>
</div>

<?php
$css_tabs = "
    .wpayme-tabs {
        margin-top: 15px;
    }
    
    .wpayme-tabs-nav {
        display: flex;
        border-bottom: 1px solid #ccc;
        margin: 0;
        padding: 0;
    }
    
    .wpayme-tabs-nav li {
        margin: 0 0 -1px 0;
        padding: 0;
        list-style: none;
    }
    
    .wpayme-tabs-nav li a {
        display: block;
        padding: 10px 15px;
        border: 1px solid transparent;
        border-bottom: none;
        text-decoration: none;
        color: #0073aa;
        margin-right: 5px;
    }
    
    .wpayme-tabs-nav li.active a {
        border-color: #ccc;
        border-bottom-color: #f1f1f1;
        background: #f1f1f1;
        color: #000;
    }
    
    .wpayme-tab {
        padding: 15px;
        border: 1px solid #ccc;
        border-top: none;
        background: #f1f1f1;
        display: none;
    }
    
    .wpayme-tab.active {
        display: block;
    }
";
wp_add_inline_style('wpayme-pay-admin', $css_tabs);

$script_tabs = "jQuery(document).ready(function($) {
    // Tab navigation
    $('.wpayme-tabs-nav a').on('click', function(e) {
        e.preventDefault();
        
        var target = $(this).attr('href');
        
        // Update active tab
        $('.wpayme-tabs-nav li').removeClass('active');
        $(this).parent().addClass('active');
        
        // Show target tab
        $('.wpayme-tab').removeClass('active');
        $(target).addClass('active');
    });
});";
wp_add_inline_script('wpayme-pay-admin', $script_tabs);
?> 