<?php
// phpcs:disable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound

/**
 * Coupon Options Meta Box
 *
 * @package Wpayme\WordPress\Pay\Forms
 */

defined('ABSPATH') || exit;
?>

<div class="wpayme-pay-form-section">
    <div class="wpayme-coupon-options-container">
        <!-- General Settings -->
        <h3><?php esc_html_e('General Settings', 'wpayme'); ?></h3>
        
        <!-- Coupon Active Status -->
        <div class="wpayme-field-row">
            <label for="wpayme_coupon_active"><?php esc_html_e('Status', 'wpayme'); ?></label>
            <p class="wpayme-field-description"><?php esc_html_e('Enable or disable this coupon', 'wpayme'); ?></p>
            <label class="wpayme-toggle-switch">
                <input type="checkbox" 
                       id="wpayme_coupon_active" 
                       name="wpayme_coupon_active" 
                       value="1" 
                       <?php checked($active, '1'); ?>>
                <span class="wpayme-toggle-slider"></span>
                <span class="wpayme-toggle-label"><?php esc_html_e('Active', 'wpayme'); ?></span>
            </label>
        </div>
        
        <!-- Coupon Code -->
        <div class="wpayme-field-row">
            <label for="wpayme_coupon_code"><?php esc_html_e('Coupon Code', 'wpayme'); ?></label>
            <p class="wpayme-field-description">
                <?php esc_html_e('Coupon code that you can share with your customers. Example: GET10OFF', 'wpayme'); ?>
            </p>
            <input type="text" 
                   id="wpayme_coupon_code" 
                   name="wpayme_coupon_code" 
                   value="<?php echo esc_attr($code); ?>" 
                   placeholder="<?php esc_attr_e('e.g. SAVE10', 'wpayme'); ?>"
                   required>
        </div>
        
        <!-- Discount Settings -->
        <h3><?php esc_html_e('Discount Settings', 'wpayme'); ?></h3>
        
        <!-- Discount Type -->
        <div class="wpayme-field-row">
            <label for="wpayme_coupon_discount_type"><?php esc_html_e('Discount Type', 'wpayme'); ?></label>
            <p class="wpayme-field-description"><?php esc_html_e('Choose between percentage or fixed amount discount', 'wpayme'); ?></p>
            <select id="wpayme_coupon_discount_type" name="wpayme_coupon_discount_type">
                <option value="percentage" <?php selected($discount_type, 'percentage'); ?>><?php esc_html_e('Percentage discount', 'wpayme'); ?></option>
                <option value="fixed_amount" <?php selected($discount_type, 'fixed_amount'); ?>><?php esc_html_e('Fixed amount discount', 'wpayme'); ?></option>
            </select>
        </div>
        
        <!-- Discount Amount -->
        <div class="wpayme-field-row">
            <label for="wpayme_coupon_discount_amount"><?php esc_html_e('Discount Amount', 'wpayme'); ?></label>
            <p class="wpayme-field-description discount-type-hint percentage-hint" <?php echo ($discount_type !== 'percentage') ? 'style="display:none;"' : ''; ?>>
                <?php esc_html_e('Enter the percentage discount (without % symbol)', 'wpayme'); ?>
            </p>
            <p class="wpayme-field-description discount-type-hint fixed-hint" <?php echo ($discount_type !== 'fixed_amount') ? 'style="display:none;"' : ''; ?>>
                <?php esc_html_e('Enter the fixed discount amount', 'wpayme'); ?>
            </p>
            <div class="wpayme-input-group">
                <span class="wpayme-input-group-prefix discount-symbol-percentage" <?php echo ($discount_type !== 'percentage') ? 'style="display:none;"' : ''; ?>>%</span>
                <span class="wpayme-input-group-prefix discount-symbol-fixed" <?php echo ($discount_type !== 'fixed_amount') ? 'style="display:none;"' : ''; ?>>€</span>
                <input type="number" 
                       id="wpayme_coupon_discount_amount" 
                       name="wpayme_coupon_discount_amount" 
                       value="<?php echo esc_attr($discount_amount); ?>" 
                       min="0" 
                       step="<?php echo ($discount_type === 'percentage') ? '1' : '0.01'; ?>"
                       required>
            </div>
        </div>
        
        <!-- Usage Limits -->
        <h3><?php esc_html_e('Usage Limits', 'wpayme'); ?></h3>
        
        <!-- Redemption Limit -->
        <div class="wpayme-field-row">
            <label for="wpayme_coupon_redemption_limit"><?php esc_html_e('Usage Limit', 'wpayme'); ?></label>
            <p class="wpayme-field-description">
                <?php esc_html_e('How many times this coupon can be used. Leave empty for unlimited.', 'wpayme'); ?>
            </p>
            <input type="number" 
                   id="wpayme_coupon_redemption_limit" 
                   name="wpayme_coupon_redemption_limit" 
                   value="<?php echo esc_attr($redemption_limit); ?>" 
                   min="0" 
                   placeholder="<?php esc_attr_e('Unlimited', 'wpayme'); ?>">
        </div>
        
        <!-- Usage per User -->
        <div class="wpayme-field-row">
            <label for="wpayme_coupon_usage_per_user"><?php esc_html_e('Usage Limit Per User', 'wpayme'); ?></label>
            <p class="wpayme-field-description">
                <?php esc_html_e('How many times this coupon can be used by a single user. Leave empty for unlimited.', 'wpayme'); ?>
            </p>
            <input type="number" 
                   id="wpayme_coupon_usage_per_user" 
                   name="wpayme_coupon_usage_per_user" 
                   value="<?php echo esc_attr($usage_per_user); ?>" 
                   min="0" 
                   placeholder="<?php esc_attr_e('Unlimited', 'wpayme'); ?>">
        </div>
        
        <!-- Minimum Purchase -->
        <div class="wpayme-field-row">
            <label for="wpayme_coupon_minimum_amount"><?php esc_html_e('Minimum Purchase Amount', 'wpayme'); ?></label>
            <p class="wpayme-field-description">
                <?php esc_html_e('Minimum purchase amount required to use this coupon. Leave empty for no minimum.', 'wpayme'); ?>
            </p>
            <div class="wpayme-input-group">
                <span class="wpayme-input-group-prefix">€</span>
                <input type="number" 
                       id="wpayme_coupon_minimum_amount" 
                       name="wpayme_coupon_minimum_amount" 
                       value="<?php echo esc_attr($minimum_amount); ?>" 
                       min="0" 
                       step="0.01" 
                       placeholder="<?php esc_attr_e('No minimum', 'wpayme'); ?>">
            </div>
        </div>
        
        <!-- Date Restrictions -->
        <h3><?php esc_html_e('Date Restrictions', 'wpayme'); ?></h3>
        
        <!-- Start Date -->
        <div class="wpayme-field-row">
            <label for="wpayme_coupon_start_date"><?php esc_html_e('Start Date', 'wpayme'); ?></label>
            <p class="wpayme-field-description">
                <?php esc_html_e('The date when this coupon becomes valid. Leave empty to make it valid immediately.', 'wpayme'); ?>
            </p>
            <input type="text" 
                   id="wpayme_coupon_start_date" 
                   name="wpayme_coupon_start_date" 
                   value="<?php echo esc_attr($start_date); ?>" 
                   class="wpayme-datepicker" 
                   placeholder="<?php esc_attr_e('YYYY-MM-DD', 'wpayme'); ?>">
        </div>
        
        <!-- Expiry Date -->
        <div class="wpayme-field-row">
            <label for="wpayme_coupon_expiry_date"><?php esc_html_e('Expiry Date', 'wpayme'); ?></label>
            <p class="wpayme-field-description">
                <?php esc_html_e('The date when this coupon expires. Leave empty for no expiration.', 'wpayme'); ?>
            </p>
            <input type="text" 
                   id="wpayme_coupon_expiry_date" 
                   name="wpayme_coupon_expiry_date" 
                   value="<?php echo esc_attr($expiry_date); ?>" 
                   class="wpayme-datepicker" 
                   placeholder="<?php esc_attr_e('YYYY-MM-DD', 'wpayme'); ?>">
        </div>
        
        <!-- Form Restrictions -->
        <h3><?php esc_html_e('Form Restrictions', 'wpayme'); ?></h3>
        
        <!-- Form Availability -->
        <div class="wpayme-field-row">
            <label><?php esc_html_e('Coupon Availability', 'wpayme'); ?></label>
            <p class="wpayme-field-description">
                <?php esc_html_e('Choose which payment forms this coupon can be applied to.', 'wpayme'); ?>
            </p>
            <label>
                <input type="radio" 
                       name="wpayme_coupon_availability" 
                       value="all" 
                       <?php checked($availability, 'all'); ?>>
                <?php esc_html_e('All payment forms', 'wpayme'); ?>
            </label>
            <br>
            <label>
                <input type="radio" 
                       name="wpayme_coupon_availability" 
                       value="specific" 
                       <?php checked($availability, 'specific'); ?>>
                <?php esc_html_e('Specific payment forms', 'wpayme'); ?>
            </label>
        </div>
        
        <!-- Specific Forms -->
        <div class="wpayme-field-row specific-forms-container" <?php echo ($availability !== 'specific') ? 'style="display:none;"' : ''; ?>>
            <label for="wpayme_coupon_specific_forms"><?php esc_html_e('Select Payment Forms', 'wpayme'); ?></label>
            <select id="wpayme_coupon_specific_forms" 
                    name="wpayme_coupon_specific_forms[]" 
                    multiple 
                    class="wpayme-select2">
                <?php
                $payment_forms = get_posts(array(
                    'post_type' => 'wpayme_pay_form',
                    'posts_per_page' => -1,
                    'post_status' => 'publish',
                ));
                
                if (!empty($payment_forms)) {
                    foreach ($payment_forms as $form) {
                        $selected = in_array($form->ID, (array) $specific_forms) ? 'selected' : '';
                        $thumbnail_id = get_post_meta($form->ID, '_wpayme_product_thumbnail', true);
                        $thumbnail_url = $thumbnail_id ? wp_get_attachment_image_url($thumbnail_id, 'thumbnail') : '';
                        $default_img = 'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNDAiIGhlaWdodD0iNDAiIHZpZXdCb3g9IjAgMCA0MCA0MCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHJlY3Qgd2lkdGg9IjQwIiBoZWlnaHQ9IjQwIiByeD0iNCIgZmlsbD0iI0YyRjJGMiIvPgo8cGF0aCBkPSJNMjAgMTBDMTYuMTMgMTAgMTMgMTMuMTMgMTMgMTdDMTMgMjAuMzMgMTUuNDMgMjMuMSAxOC41IDIzLjlWMjZIMTVWMjlIMTguNVYzMUgyMS41VjI5SDI1VjI2SDIxLjVWMjMuOUMyNC41NyAyMy4xIDI3IDIwLjMzIDI3IDE3QzI3IDEzLjEzIDIzLjg3IDEwIDIwIDEwWk0yMCAyMUMxNy4yNCwyMSAxNSwxOC43NiAxNSwxN0MxNSwxNS4yNCAxNy4yNCwxMyAyMCwxM0MyMi43NiwxMyAyNSwxNS4yNCAyNSwxN0MyNSwxOC43NiAyMi43NiwyMSAyMCwyMVoiIGZpbGw9IiM2NjY2NjYiLz4KPC9zdmc+';
                        $img_url = $thumbnail_url ? $thumbnail_url : $default_img;
                        echo '<option value="' . esc_attr($form->ID) . '" ' . esc_attr( $selected ) . ' data-img="' . esc_url($img_url) . '">' 
                            . esc_html($form->post_title) . ' - ID: ' . esc_html($form->ID) . '</option>';
                    }
                } else {
                    echo '<option value="" disabled>' . esc_html__('No payment forms found', 'wpayme') . '</option>';
                }
                ?>
            </select>
            <p class="wpayme-field-description">
                <?php esc_html_e('Select the payment forms this coupon can be used with. If none are selected when "Specific payment forms" is chosen, the coupon won\'t be applicable to any form.', 'wpayme'); ?>
            </p>
        </div>
    </div>
</div>

<?php
$css = "
/* Coupon Admin Styles */
.wpayme-field-row {
    margin-bottom: 20px;
}

.wpayme-field-row label {
    display: block;
    font-weight: 600;
    margin-bottom: 5px;
}

.wpayme-field-description {
    margin-top: 2px;
    margin-bottom: 8px;
    color: #666;
    font-style: italic;
}

.wpayme-pay-form-section h3 {
    margin: 25px 0 15px;
    padding-bottom: 5px;
    border-bottom: 1px solid #eee;
}

input[type=\"text\"],
input[type=\"number\"],
select {
    width: 100%;
    padding: 8px;
    border: 1px solid #ddd;
    border-radius: 4px;
}

#wpayme_coupon_discount_type {
    line-height: 1;
}

/* Toggle Switch */
.wpayme-toggle-switch {
    position: relative;
    display: inline-block;
    width: 60px;
    height: 30px;
    margin-right: 10px;
}

.wpayme-toggle-switch input { 
    opacity: 0;
    width: 0;
    height: 0;
}

.wpayme-toggle-slider {
    position: absolute;
    cursor: pointer;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background-color: #ccc;
    transition: .4s;
    border-radius: 34px;
}

.wpayme-toggle-slider:before {
    position: absolute;
    content: \"\";
    height: 22px;
    width: 22px;
    left: 4px;
    bottom: 4px;
    background-color: white;
    transition: .4s;
    border-radius: 50%;
}

input:checked + .wpayme-toggle-slider {
    background-color: #2196F3;
}

input:checked + .wpayme-toggle-slider:before {
    transform: translateX(30px);
}

.wpayme-toggle-label {
    vertical-align: super;
    margin-left: 70px;
}

/* Input Groups */
.wpayme-input-group {
    position: relative;
    display: flex;
    align-items: center;
}

.wpayme-input-group-prefix {
    position: absolute;
    left: 10px;
    color: #666;
    font-weight: bold;
}

.wpayme-input-group input {
    padding-left: 25px;
}

/* Update the padding for discount input specifically */
#wpayme_coupon_discount_amount, 
#wpayme_coupon_minimum_amount {
    padding-left: 30px;
}

/* Select2 Styling */
.wpayme-select2 {
    width: 100%;
}

.select2-container--default .select2-selection--multiple {
    border-color: #ddd;
    border-radius: 4px;
}

.select2-container--default.select2-container--focus .select2-selection--multiple {
    border-color: #2196F3;
    box-shadow: 0 0 5px rgba(33, 150, 243, 0.3);
}

.select2-container--default .select2-selection--multiple .select2-selection__choice {
    background-color: #f0f8ff;
    border-color: #c5e0fa;
    color: #0073aa;
    font-size: 13px;
    padding: 3px 8px 3px 25px;
    margin-top: 4px;
    position: relative;
}

.select2-container--default .select2-selection--multiple .select2-selection__choice__remove {
    color: #0073aa;
    margin-right: 5px;
    position: absolute;
    left: 6px;
    top: 50%;
    transform: translateY(-50%);
}

.select2-container--default .select2-selection--multiple .select2-selection__choice__remove:hover {
    color: #ff0000;
}

.select2-dropdown {
    border-color: #ddd;
    box-shadow: 0 3px 5px rgba(0, 0, 0, 0.1);
}

/* Fix blue background on hover */
.select2-container--default .select2-results__option--highlighted[aria-selected] {
    background-color: #f3f5f6 !important;
    color: #0073aa !important;
}

.select2-container--default .select2-results__option[aria-selected=true] {
    background-color: #e6f3fa !important;
    color: #0073aa !important;
}

.select2-container--default .select2-results__option {
    padding: 8px 12px;
    margin: 0;
    font-size: 14px;
}

.select2-container--default .select2-search--dropdown .select2-search__field {
    border-color: #ddd;
    border-radius: 3px;
}

.wpayme-select2-dropdown .select2-results__option--highlighted[aria-selected] {
    background-color: #f3f5f6 !important;
    color: #0073aa !important;
}

.wpayme-select2-dropdown .select2-results__option[aria-selected=true] {
    background-color: #e6f3fa !important;
    color: #0073aa !important;
}

.wpayme-select2-dropdown .select2-results__option {
    padding: 8px 12px;
    transition: all 0.2s ease;
}

.wpayme-select2-dropdown .select2-results__option:hover {
    background-color: #f3f5f6 !important;
    color: #0073aa !important;
}

.wpayme-select-form {
    display: block;
    padding: 2px 0;
}

/* Fix the dropdown loading issues */
.select2-container--open .select2-dropdown {
    animation: select2FadeIn 0.2s ease-in-out;
}

@keyframes select2FadeIn {
    from {
        opacity: 0;
        transform: translateY(-5px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

/* jQuery UI Datepicker Styling */
.ui-datepicker {
    background-color: #fff;
    border: 1px solid #ddd;
    border-radius: 4px;
    box-shadow: 0 3px 6px rgba(0,0,0,0.16);
    display: none;
    margin-top: 4px;
    padding: 12px;
    width: 260px;
}

.ui-datepicker .ui-datepicker-header {
    margin-bottom: 8px;
    text-align: center;
    position: relative;
    padding: 5px 0;
    border-bottom: 1px solid #f0f0f0;
}

.ui-datepicker .ui-datepicker-prev,
.ui-datepicker .ui-datepicker-next {
    height: 20px;
    width: 30px;
    display: block;
    position: absolute;
    top: 4px;
    cursor: pointer;
    color: #666;
    text-decoration: none;
}

.ui-datepicker .ui-datepicker-prev {
    left: 2px;
}

.ui-datepicker .ui-datepicker-next {
    right: 2px;
}

.ui-datepicker .ui-datepicker-prev span,
.ui-datepicker .ui-datepicker-next span {
    display: block;
    position: absolute;
    left: 50%;
    margin-left: -8px;
    top: 50%;
    margin-top: -8px;
}

.ui-datepicker .ui-datepicker-prev:before {
    content: \"←\";
    font-size: 14px;
    position: absolute;
    left: 10px;
}

.ui-datepicker .ui-datepicker-next:before {
    content: \"→\";
    font-size: 14px;
    position: absolute;
    right: 10px;
}

.ui-datepicker .ui-datepicker-title {
    margin: 0 35px;
    line-height: 1.8em;
    text-align: center;
    font-weight: bold;
}

.ui-datepicker .ui-datepicker-title select {
    font-size: 1em;
    margin: 1px 0;
    border: 1px solid #ddd;
    padding: 2px 5px;
}

.ui-datepicker table {
    width: 100%;
    font-size: 13px;
    margin: 0;
    border-collapse: collapse;
}

.ui-datepicker th {
    padding: 8px 5px;
    text-align: center;
    font-weight: bold;
    border: 0;
    color: #666;
}

.ui-datepicker td {
    border: 0;
    padding: 1px;
}

.ui-datepicker td span,
.ui-datepicker td a {
    display: block;
    padding: 5px;
    text-align: center;
    text-decoration: none;
    border-radius: 3px;
}

.ui-datepicker .ui-state-default {
    background: #f5f5f5;
    color: #333;
    border: 1px solid #f5f5f5;
}

.ui-datepicker .ui-state-hover {
    background: #e6f3fa;
    color: #0073aa;
}

.ui-datepicker .ui-state-active {
    background: #0073aa;
    color: #fff;
}

.ui-datepicker .ui-state-highlight {
    background: #ffffe0;
    border: 1px solid #ffdc7d;
    color: #333;
}

.ui-datepicker .ui-datepicker-buttonpane {
    background-image: none;
    margin: .7em 0 0 0;
    padding: 0 .2em;
    border-top: 1px solid #f0f0f0;
}

.ui-datepicker .ui-datepicker-buttonpane button {
    float: right;
    margin: .5em .2em .4em;
    cursor: pointer;
    padding: 5px 10px;
    background: #f7f7f7;
    border: 1px solid #ccc;
    border-radius: 3px;
    font-size: 12px;
    color: #555;
}

/* Datepicker Input Styling */
.wpayme-datepicker {
    background-image: url('data:image/svg+xml;utf8,<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" height=\"16\" viewBox=\"0 0 24 24\" fill=\"none\" stroke=\"currentColor\" stroke-width=\"2\" stroke-linecap=\"round\" stroke-linejoin=\"round\"><rect x=\"3\" y=\"4\" width=\"18\" height=\"18\" rx=\"2\" ry=\"2\"></rect><line x=\"16\" y=\"2\" x2=\"16\" y2=\"6\"></line><line x=\"8\" y=\"2\" x2=\"8\" y2=\"6\"></line><line x=\"3\" y=\"10\" x2=\"21\" y2=\"10\"></line></svg>');
    background-repeat: no-repeat;
    background-position: right 8px center;
    background-size: 16px;
    padding-right: 32px !important;
}

.wpayme-datepicker.date-selected {
    border-color: #2196F3;
    background-color: #f0f8ff;
}

/* Fix z-index issues */
#ui-datepicker-div {
    z-index: 1000 !important;
}

/* Form thumbnails in select dropdown */
.wpayme-form-option {
    display: flex;
    align-items: center;
    padding: 8px 0;
}

.wpayme-form-thumbnail {
    width: 40px;
    height: 40px;
    object-fit: cover;
    border-radius: 4px;
    margin-right: 10px;
    border: 1px solid #ddd;
    background-color: #f9f9f9;
}

.wpayme-form-thumbnail-small {
    width: 24px;
    height: 24px;
    object-fit: cover;
    border-radius: 3px;
    margin-right: 8px;
    border: 1px solid #ddd;
    background-color: #f9f9f9;
}

.wpayme-form-text {
    flex: 1;
    font-size: 14px;
    line-height: 1.4;
}

/* Adjust dropdown items */
.select2-results__option {
    padding: 6px 12px !important;
}

/* Adjust selected items in the select2 control */
.select2-container--default .select2-selection--multiple .select2-selection__choice {
    display: flex !important;
    align-items: center;
    padding: 4px 8px 4px 25px !important;
}
";
wp_add_inline_style('wpayme-pay-admin', $css);

$script = "jQuery(document).ready(function($) {
    // Initialize datepickers
    $('.wpayme-datepicker').datepicker({
        dateFormat: 'yy-mm-dd',
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        yearRange: 'c-10:c+10',
        beforeShow: function(input, inst) {
            // Ensure the datepicker is properly positioned
            setTimeout(function() {
                inst.dpDiv.css({
                    top: $(input).offset().top + $(input).outerHeight() + 10,
                    left: $(input).offset().left
                });
            }, 0);
        },
        onSelect: function(dateText, inst) {
            // Add a visual indicator that the date was selected
            $(this).addClass('date-selected');
        }
    });
    
    // Initialize select2
    $('.wpayme-select2').select2({
        placeholder: \"Select payment forms\",
        width: '100%',
        allowClear: true,
        closeOnSelect: false,
        dropdownCssClass: \"wpayme-select2-dropdown\",
        templateResult: formatPaymentForm,
        templateSelection: formatPaymentFormSelection,
        language: {
            noResults: function() {
                return \"No payment forms found\";
            }
        }
    });
    
    // Format dropdown items
    function formatPaymentForm(form) {
        if (!form.id) {
            return form.text;
        }
        
        var imageUrl = $(form.element).data('img');
        
        var \$form = $(
            '<div class=\"wpayme-form-option\">' +
                '<img src=\"' + imageUrl + '\" class=\"wpayme-form-thumbnail\" />' +
                '<span class=\"wpayme-form-text\">' + form.text + '</span>' +
            '</div>'
        );
        
        return \$form;
    }
    
    // Format selected items
    function formatPaymentFormSelection(form) {
        if (!form.id) {
            return form.text;
        }
        
        var imageUrl = $(form.element).data('img');
        
        var \$form = $(
            '<div class=\"wpayme-form-option\">' +
                '<img src=\"' + imageUrl + '\" class=\"wpayme-form-thumbnail-small\" />' +
                '<span class=\"wpayme-form-text\">' + form.text + '</span>' +
            '</div>'
        );
        
        return \$form;
    }
    
    // Toggle specific forms container
    $('input[name=\"wpayme_coupon_availability\"]').on('change', function() {
        if ($(this).val() === 'specific') {
            $('.specific-forms-container').show();
        } else {
            $('.specific-forms-container').hide();
        }
    });
    
    // Toggle discount type hints and symbols
    $('#wpayme_coupon_discount_type').on('change', function() {
        var type = $(this).val();
        
        $('.discount-type-hint').hide();
        $('.wpayme-input-group-prefix').hide();
        
        if (type === 'percentage') {
            $('.percentage-hint').show();
            $('.discount-symbol-percentage').show();
            $('#wpayme_coupon_discount_amount').attr('step', '1');
        } else {
            $('.fixed-hint').show();
            $('.discount-symbol-fixed').show();
            $('#wpayme_coupon_discount_amount').attr('step', '0.01');
        }
    });
});";
wp_add_inline_script('wpayme-pay-admin', $script);
?> 