<?php
// phpcs:disable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Simple Form for Testing
 */

// Get form ID from parameter
$form_id = isset($args['form_id']) ? $args['form_id'] : 0;

if (!$form_id) {
    return '<p>Error: No form ID provided</p>';
}

// Get basic form data
$title = get_the_title($form_id);
$description = get_post_meta($form_id, '_wpayme_product_description', true);
?>

<div class="wpayme-pay-form-wrap">
    <form id="wpayme-pay-form-<?php echo esc_attr($form_id); ?>" class="wpayme-pay-form" method="post">
        <?php wp_nonce_field('wpayme_pay_submit_form', 'wpayme_pay_nonce'); ?>
        <input type="hidden" name="form_id" value="<?php echo esc_attr($form_id); ?>">
        
        <h2><?php echo esc_html($title); ?></h2>
        
        <?php if ($description) : ?>
            <div class="wpayme-pay-product-description">
                <?php echo wp_kses_post($description); ?>
            </div>
        <?php endif; ?>
        
        <div class="wpayme-pay-amount-input-only">
            <span class="wpayme-pay-currency-symbol">€</span>
            <input type="number" 
                   name="wpayme_pay_amount" 
                   step="0.01" 
                   min="0.01" 
                   required="required" 
                   placeholder="<?php esc_attr_e('Enter amount', 'wpayme'); ?>"
                   class="wpayme-pay-amount-input">
        </div>
        
        <div class="wpayme-pay-submit-button-wrap">
            <button type="submit" class="wpayme-pay-submit">
                <?php esc_html_e('Pay Now', 'wpayme'); ?>
            </button>
        </div>
    </form>
</div> 