<?php
/**
 * Forms install.
 *
 * @author    Wpayme <hi@wpayme.com>
 * @copyright 2024-2025 Wpayme
 * @license   GPL-3.0-or-later
 * @package   Wpayme\WordPress\Pay
 */

namespace Wpayme\WordPress\Pay\Forms;

use Wpayme\WordPress\Pay\Upgrades\Upgrade;

/**
 * Install class
 */
class Install extends Upgrade {
	/**
	 * Execute.
	 *
	 * @link https://github.com/woocommerce/woocommerce/blob/4.0.0/includes/class-wc-install.php#L272-L306
	 * @return void
	 */
	public function execute() {
		// Add forms capabilities to administrator role.
		$roles = wp_roles();

		$form_capabilities = FormPostType::get_capabilities();

		foreach ( $form_capabilities as $capability ) {
			$roles->add_cap( 'administrator', $capability );
		}
	}
}
