<?php
/**
 * Coupon admin.
 *
 * @author    Wpayme <hi@wpayme.com>
 * @copyright 2024-2025 Wpayme
 * @license   GPL-3.0-or-later
 * @package   Wpayme\WordPress\Pay\Forms
 */

namespace Wpayme\WordPress\Pay\Forms;

// Make sure the CouponPostType class exists
if (!class_exists('Wpayme\\WordPress\\Pay\\Forms\\CouponPostType')) {
    require_once __DIR__ . '/CouponPostType.php';
}

/**
 * Coupon Admin class
 */
class CouponAdmin {
    /**
     * Construct and initialize coupon admin.
     */
    public function __construct() {
        // We don't need to add the submenu here anymore as it's handled by AdminModule
        // Just hook the parent_file filter for screen highlighting
        \add_filter('parent_file', [$this, 'admin_menu_parent_file']);
    }

    /**
     * Admin menu parent file.
     *
     * @param string $parent_file Parent file for admin menu.
     * @return string
     */
    public function admin_menu_parent_file($parent_file) {
        $screen = \get_current_screen();

        if (null === $screen) {
            return $parent_file;
        }

        if ($screen->post_type === CouponPostType::POST_TYPE) {
            return 'wpayme';
        }

        return $parent_file;
    }
} 