<?php
/**
 * Forms admin.
 *
 * @author    Wpayme <hi@wpayme.com>
 * @copyright 2024-2025 Wpayme
 * @license   GPL-3.0-or-later
 * @package   Wpayme\WordPress\Pay
 */

namespace Wpayme\WordPress\Pay\Forms;

// Make sure FormPostType and CouponPostType classes exist
if (!class_exists('Wpayme\\WordPress\\Pay\\Forms\\FormPostType')) {
	require_once __DIR__ . '/FormPostType.php';
}

if (!class_exists('Wpayme\\WordPress\\Pay\\Forms\\CouponPostType')) {
	require_once __DIR__ . '/CouponPostType.php';
}

/**
 * Admin class
 */
class Admin {
	/**
	 * Construct and initialize forms admin.
	 */
	public function __construct() {
		\add_action( 'admin_menu', [ $this, 'admin_menu' ] );
		\add_filter( 'parent_file', [ $this, 'admin_menu_parent_file' ] );
	}

	/**
	 * Add submenu pages.
	 *
	 * @return void
	 */
	public function admin_menu() {
		\add_submenu_page(
			'wpayme',
			\__( 'Payment Forms', 'wpayme' ),
			\__( 'Forms', 'wpayme' ),
			'edit_forms',
			'edit.php?post_type=wpayme_pay_form',
			'',
			3,
		);
	}

	/**
	 * Admin menu parent file.
	 *
	 * @param string $parent_file Parent file for admin menu.
	 * @return string
	 */
	public function admin_menu_parent_file( $parent_file ) {
		$screen = \get_current_screen();

		if ( null === $screen ) {
			return $parent_file;
		}

		switch ( $screen->id ) {
			case FormPostType::POST_TYPE:
			case 'wpayme_coupon': // Also handle coupons
				return 'wpayme';
		}

		return $parent_file;
	}
}
