/**
 * Frontend Payment Methods Script
 *
 * Handles the display of payment methods in the frontend form.
 *
 * @package Wpayme\WordPress\Pay\Forms
 */

(function($) {
    'use strict';

    // Initialize when document is ready
    $(document).ready(function() {
        // Get the config ID from the hidden input
        const configId = $('input[name="wpayme_pay_config_id"]').val();
        const $paymentMethodsContainer = $('.wpayme-pay-payment-methods-container');
        
        if (!configId || !$paymentMethodsContainer.length) {
            return;
        }
        
        // Function to fetch and display payment methods
        function loadPaymentMethods() {
            $paymentMethodsContainer.html('<p class="wpayme-pay-loading">' + wpaymePayFrontend.loadingText + '</p>');
            
            // Fetch payment methods via AJAX
            $.ajax({
                url: wpaymePayFrontend.ajaxUrl,
                type: 'POST',
                data: {
                    action: 'wpayme_get_gateway_payment_methods',
                    config_id: configId,
                    nonce: wpaymePayFrontend.nonce
                },
                success: function(response) {
                    if (response.success) {
                        if (response.data.methods && response.data.methods.length > 0) {
                            let html = '<ul class="wpayme-pay-payment-methods-list">';
                            
                            // Filter to only show active methods
                            const activeMethods = response.data.methods.filter(function(method) {
                                return method.status === 'active';
                            });
                            
                            if (activeMethods.length === 0) {
                                $paymentMethodsContainer.html('<p class="wpayme-pay-no-methods">' + wpaymePayFrontend.noMethodsText + '</p>');
                                return;
                            }
                            
                            activeMethods.forEach(function(method, index) {
                                html += '<li class="wpayme-pay-payment-method-item">';
                                
                                // Add radio button for selection
                                html += '<input type="radio" id="wpayme-pay-method-' + method.id + '" ' +
                                       'name="wpayme_pay_method" value="' + method.id + '" ' +
                                       (index === 0 ? 'checked' : '') + ' required>';
                                
                                html += '<label for="wpayme-pay-method-' + method.id + '">';
                                html += '<span class="wpayme-pay-method-name">' + method.name + '</span>';
                                
                                // Add recurring indicator if applicable
                                if (method.supports_recurring) {
                                    html += '<span class="wpayme-pay-method-recurring">' + wpaymePayFrontend.recurringText + '</span>';
                                }
                                
                                html += '</label>';
                                html += '</li>';
                            });
                            
                            html += '</ul>';
                            $paymentMethodsContainer.html(html);
                        } else {
                            $paymentMethodsContainer.html('<p class="wpayme-pay-no-methods">' + wpaymePayFrontend.noMethodsText + '</p>');
                        }
                    } else {
                        $paymentMethodsContainer.html('<p class="wpayme-pay-error">' + wpaymePayFrontend.errorText + '</p>');
                    }
                },
                error: function() {
                    $paymentMethodsContainer.html('<p class="wpayme-pay-error">' + wpaymePayFrontend.errorText + '</p>');
                }
            });
        }
        
        // Load payment methods when the page loads
        loadPaymentMethods();
    });
    
})(jQuery); 