/* globals wpayme_payment_form */

( function ( wp, blocks, components, editor, element ) {
	var el = element.createElement;
	var Fragment = element.Fragment;
	var InspectorControls = editor.InspectorControls;
	var Button = components.Button;
	var Placeholder = components.Placeholder;
	var TextControl = components.TextControl;
	var SelectControl = components.SelectControl;
	var ServerSideRender = wp.serverSideRender;
	const { registerBlockType } = wp.blocks;
	const { __ } = wp.i18n;
	const { useState } = wp.element;

	/**
	 * Register payment form block type.
	 *
	 * @param string name     Block name.
	 * @param object settings Block settings.
	 *
	 * @return WPBlock        Block if registered successfully, otherwise "undefined".
	 */
	registerBlockType( 'wpayme-pay/payment-form', {
		title: wpayme_payment_form.title,
		icon: 'welcome-widgets-menus',
		category: 'widgets',

		// Attributes.
		attributes: {
			amount: {
				type: 'string',
				default: ''
			},
			formId: {
				type: 'string',
				default: ''
			}
		},

		// Feature supports.
		supports: {
			html: false
		},

		// Edit.
		edit: function ( props ) {
			const { attributes, setAttributes } = props;
			const { formId, amount } = attributes;

			const onChangeForm = ( value ) => {
				setAttributes( { formId: value } );
			};

			const onChangeAmount = ( value ) => {
				setAttributes( { amount: value } );
			};

			// Get the selected form name
			const selectedForm = wpayme_payment_form.forms.find(form => form.value === formId);
			const formName = selectedForm ? selectedForm.label : '';

			return [
				el( InspectorControls, {},
					el( Fragment, null,
						el( 'div', {
							className: 'block-editor-block-inspector',
							style: {
								padding: '16px'
							}
						},
							el( SelectControl, {
								label: wpayme_payment_form.label_select_form,
								value: formId,
								options: wpayme_payment_form.forms,
								onChange: onChangeForm
							} )
						)
					)
				),
				el( 'div', {
					className: 'wpayme-payment-form-block',
					style: {
						padding: '16px',
						border: '1px solid #ddd',
						borderRadius: '4px',
						backgroundColor: '#fff'
					}
				},
					[
						el( 'div', {
							style: {
								marginBottom: '16px'
							}
						},
							el( 'h3', {}, __( 'Payment Form', 'wpayme' ) )
						),
						el( 'div', {
							style: {
								marginBottom: '16px',
								padding: '8px',
								backgroundColor: '#f8f9fa',
								borderRadius: '4px',
								border: '1px solid #e2e4e7'
							}
						},
							el( SelectControl, {
								label: wpayme_payment_form.label_select_form,
								value: formId,
								options: wpayme_payment_form.forms,
								onChange: onChangeForm,
								className: 'wpayme-form-selector'
							} )
						),
						formId ? [
							el( 'div', {
								style: {
									marginBottom: '8px',
									fontWeight: 'bold',
									fontSize: '16px',
									color: '#1e1e1e'
								}
							}, 
								formName
							),
							el( 'p', {}, __( 'This payment form will be displayed on the frontend.', 'wpayme' ) )
						] : el( 'p', {
							style: {
								color: '#666',
								fontStyle: 'italic'
							}
						}, __( 'Please select a form to display.', 'wpayme' ) )
					]
				)
			];
		},

		// Save.
		save: function () {
			return null;
		}
	} );
} )(
	window.wp,
	window.wp.blocks,
	window.wp.components,
	window.wp.blockEditor,
	window.wp.element
);
