// Coupon Admin Script
(function($) {
    'use strict';

    $(document).ready(function() {
        // Initialize datepicker for date fields
        if ($.fn.datepicker) {
            $('input[type="date"]').datepicker({
                dateFormat: 'yy-mm-dd',
                changeMonth: true,
                changeYear: true
            });
        }
        
        // Toggle specific products section based on availability option
        $('input[name="wpayme_coupon_availability"]').on('change', function() {
            if ($(this).val() === 'specific') {
                $('#wpayme-specific-products').slideDown(200, function() {
                    // Re-initialize Select2 after the container is visible
                    initSelect2();
                });
            } else {
                $('#wpayme-specific-products').slideUp(200);
            }
        });
        
        // Initialize Select2 for the multi-select
        function initSelect2() {
            $('#wpayme_coupon_specific_products').select2({
                width: '100%',
                placeholder: 'Select payment forms',
                allowClear: true,
                closeOnSelect: false,
                tags: false,
                tokenSeparators: [','],
                theme: 'classic'
            });
        }
        
        // Initialize Select2 on page load if the specific products section is visible
        if ($('#wpayme-specific-products').is(':visible')) {
            initSelect2();
        }
        
        // Update discount symbol based on discount type
        $('#wpayme_coupon_discount_type').on('change', function() {
            var symbol = ($(this).val() === 'percentage') ? '%' : '€';
            $('#wpayme-discount-symbol').text(symbol);
        });
        
        // Fix for the discount symbol on load
        var currentDiscountType = $('#wpayme_coupon_discount_type').val();
        var symbol = (currentDiscountType === 'percentage') ? '%' : '€';
        $('#wpayme-discount-symbol').text(symbol);
    });

})(jQuery); 