<?php
/**
 * Currencies
 *
 * @author    Wpayme <hi@wpayme.com>
 * @copyright 2024-2025 Wpayme
 * @license   GPL-3.0-or-later
 * @package   Wpayme\WordPress\Money
 */

namespace Wpayme\WordPress\Money;

/**
 * Currencies
 *
 * @link https://github.com/moneyphp/money/blob/v3.1.3/src/Currencies/ISOCurrencies.php#L90-L102
 * @link https://github.com/moneyphp/money/blob/v3.1.3/resources/currency.php
 *
 * @author Remco Tolsma
 * @version 1.2.2
 */
return [
	new Currency(
		'AED',
		'784',
		__( 'UAE Dirham', 'wpayme' ),
		'د.إ',
		2
	),
	new Currency(
		'AFN',
		'971',
		__( 'Afghan Afghani', 'wpayme' ),
		'؋',
		2
	),
	new Currency(
		'ALL',
		'008',
		__( 'Albanian Lek', 'wpayme' ),
		'L',
		2
	),
	new Currency(
		'AMD',
		'051',
		__( 'Armenian Dram', 'wpayme' ),
		'֏',
		2
	),
	new Currency(
		'ANG',
		'532',
		__( 'Netherlands Antillean Guilder', 'wpayme' ),
		'ƒ',
		2
	),
	new Currency(
		'AOA',
		'973',
		__( 'Angolan Kwanza', 'wpayme' ),
		'Kz',
		2
	),
	new Currency(
		'ARS',
		'032',
		__( 'Argentine Peso', 'wpayme' ),
		'$',
		2
	),
	new Currency(
		'AUD',
		'036',
		__( 'Australian Dollar', 'wpayme' ),
		'$',
		2
	),
	new Currency(
		'AWG',
		'533',
		__( 'Aruban Florin', 'wpayme' ),
		'ƒ',
		2
	),
	new Currency(
		'AZN',
		'944',
		__( 'Azerbaijan Manat', 'wpayme' ),
		'₼',
		2
	),
	new Currency(
		'BAM',
		'977',
		__( 'Bosnia and Herzegovina Convertible Mark', 'wpayme' ),
		'KM',
		2
	),
	new Currency(
		'BBD',
		'052',
		__( 'Barbados Dollar', 'wpayme' ),
		'$',
		2
	),
	new Currency(
		'BDT',
		'050',
		__( 'Bangladeshi Taka', 'wpayme' ),
		'৳',
		2
	),
	new Currency(
		'BGN',
		'975',
		__( 'Bulgarian Lev', 'wpayme' ),
		'лв.',
		2
	),
	new Currency(
		'BHD',
		'048',
		__( 'Bahraini Dinar', 'wpayme' ),
		'.د.ب',
		3
	),
	new Currency(
		'BIF',
		'108',
		__( 'Burundian Franc', 'wpayme' ),
		'FBu',
		0
	),
	new Currency(
		'BMD',
		'060',
		__( 'Bermudian Dollar', 'wpayme' ),
		'$',
		2
	),
	new Currency(
		'BND',
		'096',
		__( 'Brunei Dollar', 'wpayme' ),
		'$',
		2
	),
	new Currency(
		'BOB',
		'068',
		__( 'Bolíviano', 'wpayme' ),
		'$b',
		2
	),
	new Currency(
		'BOV',
		'984',
		__( 'Bolivian Mvdol', 'wpayme' ),
		null,
		2
	),
	new Currency(
		'BRL',
		'986',
		__( 'Brazilian Real', 'wpayme' ),
		'R$',
		2
	),
	new Currency(
		'BSD',
		'044',
		__( 'Bahamian Dollar', 'wpayme' ),
		'$',
		2
	),
	new Currency(
		'BTN',
		'064',
		__( 'Bhutanese Ngultrum', 'wpayme' ),
		'Nu.',
		2
	),
	new Currency(
		'BWP',
		'072',
		__( 'Botswana Pula', 'wpayme' ),
		'P',
		2
	),
	new Currency(
		'BYN',
		'933',
		__( 'Belarusian Ruble', 'wpayme' ),
		'Br',
		2
	),
	new Currency(
		'BZD',
		'084',
		__( 'Belize Dollar', 'wpayme' ),
		'$',
		2
	),
	new Currency(
		'CAD',
		'124',
		__( 'Canadian Dollar', 'wpayme' ),
		'$',
		2
	),
	new Currency(
		'CDF',
		'976',
		__( 'Congolese Franc', 'wpayme' ),
		'F',
		2
	),
	new Currency(
		'CHE',
		'947',
		__( 'WIR Euro', 'wpayme' ),
		'€',
		2
	),
	new Currency(
		'CHF',
		'756',
		__( 'Swiss Franc', 'wpayme' ),
		'F',
		2
	),
	new Currency(
		'CHW',
		'948',
		__( 'WIR Franc', 'wpayme' ),
		'F',
		2
	),
	new Currency(
		'CLF',
		'990',
		__( 'Unidad de Fomento', 'wpayme' ),
		'UF',
		4
	),
	new Currency(
		'CLP',
		'152',
		__( 'Chilean Peso', 'wpayme' ),
		'$',
		0
	),
	new Currency(
		'CNY',
		'156',
		__( 'Renminbi Yuan', 'wpayme' ),
		'元',
		2
	),
	new Currency(
		'COP',
		'170',
		__( 'Colombian Peso', 'wpayme' ),
		'$',
		2
	),
	new Currency(
		'COU',
		'970',
		__( 'Unidad de Valor Real', 'wpayme' ),
		'$',
		2
	),
	new Currency(
		'CRC',
		'188',
		__( 'Costa Rican Colon', 'wpayme' ),
		'₡',
		2
	),
	new Currency(
		'CUC',
		'931',
		__( 'Cuban Convertible Peso', 'wpayme' ),
		'$',
		2
	),
	new Currency(
		'CUP',
		'192',
		__( 'Cuban Peso', 'wpayme' ),
		'$',
		2
	),
	new Currency(
		'CVE',
		'132',
		__( 'Cape Verde Escudo', 'wpayme' ),
		'Esc',
		2
	),
	new Currency(
		'CZK',
		'203',
		__( 'Czech Koruna', 'wpayme' ),
		'Kč',
		2
	),
	new Currency(
		'DJF',
		'262',
		__( 'Djiboutian Franc', 'wpayme' ),
		'F',
		0
	),
	new Currency(
		'DKK',
		'208',
		__( 'Danish Krone', 'wpayme' ),
		'kr',
		2
	),
	new Currency(
		'DOP',
		'214',
		__( 'Dominican Peso', 'wpayme' ),
		'$',
		2
	),
	new Currency(
		'DZD',
		'012',
		__( 'Algerian Dinar', 'wpayme' ),
		'دج',
		2
	),
	new Currency(
		'EGP',
		'818',
		__( 'Egyptian Pound', 'wpayme' ),
		'£',
		2
	),
	new Currency(
		'ERN',
		'232',
		__( 'Eritrean Nakfa', 'wpayme' ),
		'Nfk',
		2
	),
	new Currency(
		'ETB',
		'230',
		__( 'Ethiopian Birr', 'wpayme' ),
		'Br',
		2
	),
	new Currency(
		'EUR',
		'978',
		__( 'Euro', 'wpayme' ),
		'€',
		2
	),
	new Currency(
		'FJD',
		'242',
		__( 'Fiji Dollar', 'wpayme' ),
		'$',
		2
	),
	new Currency(
		'FKP',
		'238',
		__( 'Falkland Islands Pound', 'wpayme' ),
		'£',
		2
	),
	new Currency(
		'GBP',
		'826',
		__( 'Pound Sterling', 'wpayme' ),
		'£',
		2
	),
	new Currency(
		'GEL',
		'981',
		__( 'Georgian Lari', 'wpayme' ),
		'ლ',
		2
	),
	new Currency(
		'GHS',
		'936',
		__( 'Ghanaian Cedi', 'wpayme' ),
		'GH₵',
		2
	),
	new Currency(
		'GIP',
		'292',
		__( 'Gibraltar Pound', 'wpayme' ),
		'£',
		2
	),
	new Currency(
		'GMD',
		'270',
		__( 'Gambian Dalasi', 'wpayme' ),
		'D',
		2
	),
	new Currency(
		'GNF',
		'324',
		__( 'Guinean Franc', 'wpayme' ),
		'F',
		0
	),
	new Currency(
		'GTQ',
		'320',
		__( 'Guatemalan Quetzal', 'wpayme' ),
		'Q',
		2
	),
	new Currency(
		'GYD',
		'328',
		__( 'Guyanese Dollar', 'wpayme' ),
		'$',
		2
	),
	new Currency(
		'HKD',
		'344',
		__( 'Hong Kong Dollar', 'wpayme' ),
		'$',
		2
	),
	new Currency(
		'HNL',
		'340',
		__( 'Honduran Lempira', 'wpayme' ),
		'L',
		2
	),
	new Currency(
		'HRK',
		'191',
		__( 'Croatian Kuna', 'wpayme' ),
		'kn',
		2
	),
	new Currency(
		'HTG',
		'332',
		__( 'Haitian Gourde', 'wpayme' ),
		'G',
		2
	),
	new Currency(
		'HUF',
		'348',
		__( 'Hungarian Forint', 'wpayme' ),
		'Ft',
		2
	),
	new Currency(
		'IDR',
		'360',
		__( 'Indonesian Rupiah', 'wpayme' ),
		'Rp',
		2
	),
	new Currency(
		'ILS',
		'376',
		__( 'Israeli New Sheqel', 'wpayme' ),
		'₪',
		2
	),
	new Currency(
		'INR',
		'356',
		__( 'Indian Rupee', 'wpayme' ),
		'₹',
		2
	),
	new Currency(
		'IQD',
		'368',
		__( 'Iraqi Dinar', 'wpayme' ),
		'د.ع',
		3
	),
	new Currency(
		'IRR',
		'364',
		__( 'Iranian Rial', 'wpayme' ),
		'﷼',
		2
	),
	new Currency(
		'ISK',
		'352',
		__( 'Icelandic Króna', 'wpayme' ),
		'kr',
		0
	),
	new Currency(
		'JMD',
		'388',
		__( 'Jamaican Dollar', 'wpayme' ),
		'$',
		2
	),
	new Currency(
		'JOD',
		'400',
		__( 'Jordanian Dinar', 'wpayme' ),
		'JD',
		3
	),
	new Currency(
		'JPY',
		'392',
		__( 'Japanese Yen', 'wpayme' ),
		'¥',
		0
	),
	new Currency(
		'KES',
		'404',
		__( 'Kenyan Shilling', 'wpayme' ),
		'Ksh',
		2
	),
	new Currency(
		'KGS',
		'417',
		__( 'Kyrgyzstani Som', 'wpayme' ),
		'С̲',
		2
	),
	new Currency(
		'KHR',
		'116',
		__( 'Cambodian Riel', 'wpayme' ),
		'៛',
		2
	),
	new Currency(
		'KMF',
		'174',
		__( 'Comorian Franc', 'wpayme' ),
		'F',
		0
	),
	new Currency(
		'KPW',
		'408',
		__( 'North Korean Won', 'wpayme' ),
		'₩',
		2
	),
	new Currency(
		'KRW',
		'410',
		__( 'South Korean Won', 'wpayme' ),
		'₩',
		0
	),
	new Currency(
		'KWD',
		'414',
		__( 'Kuwaiti Dinar', 'wpayme' ),
		'د.ك',
		3
	),
	new Currency(
		'KYD',
		'136',
		__( 'Cayman Islands Dollar', 'wpayme' ),
		'$',
		2
	),
	new Currency(
		'KZT',
		'398',
		__( 'Kazakhstani Tenge', 'wpayme' ),
		'₸',
		2
	),
	new Currency(
		'LAK',
		'418',
		__( 'Lao Kip', 'wpayme' ),
		'₭',
		2
	),
	new Currency(
		'LBP',
		'422',
		__( 'Lebanese Pound', 'wpayme' ),
		'LL',
		2
	),
	new Currency(
		'LKR',
		'144',
		__( 'Sri Lankan Rupee', 'wpayme' ),
		'₨',
		2
	),
	new Currency(
		'LRD',
		'430',
		__( 'Liberian Dollar', 'wpayme' ),
		'$',
		2
	),
	new Currency(
		'LSL',
		'426',
		__( 'Lesotho Loti', 'wpayme' ),
		/**
		 * Symbol based on plural form "maloti". The one-loti note employs the symbol L.
		 *
		 * @link https://en.wikipedia.org/wiki/Currency_symbol#List_of_currency_symbols_currently_in_use
		 */
		'M',
		2
	),
	new Currency(
		'LYD',
		'434',
		__( 'Libyan Dinar', 'wpayme' ),
		'ل.د',
		3
	),
	new Currency(
		'MAD',
		'504',
		__( 'Moroccan Dirham', 'wpayme' ),
		'د.م.',
		2
	),
	new Currency(
		'MDL',
		'498',
		__( 'Moldovan Leu', 'wpayme' ),
		'L',
		2
	),
	new Currency(
		'MGA',
		'969',
		__( 'Malagasy Ariary', 'wpayme' ),
		'Ar',
		2
	),
	new Currency(
		'MKD',
		'807',
		__( 'Macedonian Denar', 'wpayme' ),
		'ден',
		2
	),
	new Currency(
		'MMK',
		'104',
		__( 'Myanmar Kyat', 'wpayme' ),
		'K',
		2
	),
	new Currency(
		'MNT',
		'496',
		__( 'Mongolian Tögrög', 'wpayme' ),
		'₮',
		2
	),
	new Currency(
		'MOP',
		'446',
		__( 'Macanese Pataca', 'wpayme' ),
		'MOP$',
		2
	),
	new Currency(
		'MRO',
		'478',
		__( 'Mauritanian Ouguiya', 'wpayme' ),
		'UM',
		2
	),
	new Currency(
		'MUR',
		'480',
		__( 'Mauritian Rupee', 'wpayme' ),
		'₨',
		2
	),
	new Currency(
		'MVR',
		'462',
		__( 'Maldivian Rufiyaa', 'wpayme' ),
		'Rf.',
		2
	),
	new Currency(
		'MWK',
		'454',
		__( 'Malawian Kwacha', 'wpayme' ),
		'K',
		2
	),
	new Currency(
		'MXN',
		'484',
		__( 'Mexican Peso', 'wpayme' ),
		'$',
		2
	),
	new Currency(
		'MXV',
		'979',
		__( 'Mexican Unidad de Inversion (UDI)', 'wpayme' ),
		'UDI',
		2
	),
	new Currency(
		'MYR',
		'458',
		__( 'Malaysian Ringgit', 'wpayme' ),
		'RM',
		2
	),
	new Currency(
		'MZN',
		'943',
		__( 'Mozambican Metical', 'wpayme' ),
		'MT',
		2
	),
	new Currency(
		'NAD',
		'516',
		__( 'Namibian Dollar', 'wpayme' ),
		'$',
		2
	),
	new Currency(
		'NGN',
		'566',
		__( 'Nigerian Naira', 'wpayme' ),
		'₦',
		2
	),
	new Currency(
		'NIO',
		'558',
		__( 'Nicaraguan Córdoba', 'wpayme' ),
		'C$',
		2
	),
	new Currency(
		'NLG',
		null,
		__( 'Gulden', 'wpayme' ),
		'G',
		4
	),
	new Currency(
		'NOK',
		'578',
		__( 'Norwegian Krone', 'wpayme' ),
		'kr',
		2
	),
	new Currency(
		'NPR',
		'524',
		__( 'Nepalese Rupee', 'wpayme' ),
		'₨',
		2
	),
	new Currency(
		'NZD',
		'554',
		__( 'New Zealand Dollar', 'wpayme' ),
		'$',
		2
	),
	new Currency(
		'OMR',
		'512',
		__( 'Omani Rial', 'wpayme' ),
		'ر.ع.',
		3
	),
	new Currency(
		'PAB',
		'590',
		__( 'Panamanian Balboa', 'wpayme' ),
		'B/.',
		2
	),
	new Currency(
		'PEN',
		'604',
		__( 'Peruvian Sol', 'wpayme' ),
		'S/',
		2
	),
	new Currency(
		'PGK',
		'598',
		__( 'Papua New Guinean Kina', 'wpayme' ),
		'K',
		2
	),
	new Currency(
		'PHP',
		'608',
		__( 'Philippine Peso', 'wpayme' ),
		'₱',
		2
	),
	new Currency(
		'PKR',
		'586',
		__( 'Pakistani Rupee', 'wpayme' ),
		'₨',
		2
	),
	new Currency(
		'PLN',
		'985',
		__( 'Polish Zloty', 'wpayme' ),
		'zł',
		2
	),
	new Currency(
		'PYG',
		'600',
		__( 'Paraguayan Guaraní', 'wpayme' ),
		'₲',
		0
	),
	new Currency(
		'QAR',
		'634',
		__( 'Qatari Rial', 'wpayme' ),
		'ر.ق',
		2
	),
	new Currency(
		'RON',
		'946',
		__( 'Romanian Leu', 'wpayme' ),
		'L',
		2
	),
	new Currency(
		'RSD',
		'941',
		__( 'Serbian Dinar', 'wpayme' ),
		'дин',
		2
	),
	new Currency(
		'RUB',
		'643',
		__( 'Russian Ruble', 'wpayme' ),
		'₽',
		2
	),
	new Currency(
		'RWF',
		'646',
		__( 'Rwandan Franc', 'wpayme' ),
		'FRw',
		0
	),
	new Currency(
		'SAR',
		'682',
		__( 'Saudi Riyal', 'wpayme' ),
		'ر.س',
		2
	),
	new Currency(
		'SBD',
		'090',
		__( 'Solomon Islands Dollar', 'wpayme' ),
		'$',
		2
	),
	new Currency(
		'SCR',
		'690',
		__( 'Seychelles Rupee', 'wpayme' ),
		'SRe',
		2
	),
	new Currency(
		'SDG',
		'938',
		__( 'Sudanese Pound', 'wpayme' ),
		'ج.س',
		2
	),
	new Currency(
		'SEK',
		'752',
		__( 'Swedish Krona', 'wpayme' ),
		'kr',
		2
	),
	new Currency(
		'SGD',
		'702',
		__( 'Singapore Dollar', 'wpayme' ),
		'$',
		2
	),
	new Currency(
		'SHP',
		'654',
		__( 'Saint Helena Pound', 'wpayme' ),
		'£',
		2
	),
	new Currency(
		'SLL',
		'694',
		__( 'Sierra Leonean Leone', 'wpayme' ),
		'Le',
		2
	),
	new Currency(
		'SOS',
		'706',
		__( 'Somali Shilling', 'wpayme' ),
		'Sh.So.',
		2
	),
	new Currency(
		'SRD',
		'968',
		__( 'Surinamese Dollar', 'wpayme' ),
		'$',
		2
	),
	new Currency(
		'SSP',
		'728',
		__( 'South Sudanese Pound', 'wpayme' ),
		'SS£',
		2
	),
	new Currency(
		'STD',
		'678',
		__( 'São Tomé and Príncipe Dobra', 'wpayme' ),
		'Db',
		2
	),
	new Currency(
		'SVC',
		'222',
		__( 'Salvadoran Colon', 'wpayme' ),
		'₡',
		2
	),
	new Currency(
		'SYP',
		'760',
		__( 'Syrian Pound', 'wpayme' ),
		'£',
		2
	),
	new Currency(
		'SZL',
		'748',
		__( 'Swazi Lilangeni', 'wpayme' ),
		/**
		 * Symbol based on the plural form "emalangeni" However the one-lilageni note employs the currency symbol L.
		 *
		 * @link https://en.wikipedia.org/wiki/Currency_symbol#List_of_currency_symbols_currently_in_use
		 */
		'E',
		2
	),
	new Currency(
		'THB',
		'764',
		__( 'Thai Baht', 'wpayme' ),
		'฿',
		2
	),
	new Currency(
		'TJS',
		'972',
		__( 'Tajikistani Somoni', 'wpayme' ),
		'SM',
		2
	),
	new Currency(
		'TMT',
		'934',
		__( 'Turkmenistan Manat', 'wpayme' ),
		'T',
		2
	),
	new Currency(
		'TND',
		'788',
		__( 'Tunisian Dinar', 'wpayme' ),
		'د.ت',
		3
	),
	new Currency(
		'TOP',
		'776',
		__( 'Tongan Pa’anga', 'wpayme' ),
		'T$',
		2
	),
	new Currency(
		'TRY',
		'949',
		__( 'Turkish Lira', 'wpayme' ),
		'₺',
		2
	),
	new Currency(
		'TTD',
		'780',
		__( 'Trinidad and Tobago Dollar', 'wpayme' ),
		'$',
		2
	),
	new Currency(
		'TWD',
		'901',
		__( 'New Taiwan Dollar', 'wpayme' ),
		'$',
		2
	),
	new Currency(
		'TZS',
		'834',
		__( 'Tanzanian Shilling', 'wpayme' ),
		'Tsh',
		2
	),
	new Currency(
		'UAH',
		'980',
		__( 'Ukrainian Hryvnia', 'wpayme' ),
		'₴',
		2
	),
	new Currency(
		'UGX',
		'800',
		__( 'Ugandan Shilling', 'wpayme' ),
		'USh',
		0
	),
	new Currency(
		'USD',
		'840',
		__( 'US Dollar', 'wpayme' ),
		'$',
		2
	),
	new Currency(
		'USN',
		'997',
		__( 'US Dollar (Next day)', 'wpayme' ),
		'$',
		2
	),
	new Currency(
		'UYI',
		'940',
		__( 'Uruguay Peso en Unidades Indexadas (URUIURUI)', 'wpayme' ),
		'$',
		0
	),
	new Currency(
		'UYU',
		'858',
		__( 'Uruguayan Peso', 'wpayme' ),
		'$',
		2
	),
	new Currency(
		'UYW',
		'927',
		__( 'Unidad Previsional', 'wpayme' ),
		null,
		4
	),
	new Currency(
		'UZS',
		'860',
		__( 'Uzbekistan Som', 'wpayme' ),
		'лв',
		2
	),
	new Currency(
		'VES',
		'928',
		__( 'Venezuelan Bolívar Soberano', 'wpayme' ),
		'Bs.S.',
		2
	),
	new Currency(
		'VND',
		'704',
		__( 'Vietnamese Dồng', 'wpayme' ),
		'₫',
		0
	),
	new Currency(
		'VUV',
		'548',
		__( 'Vanuatu Vatu', 'wpayme' ),
		'VT',
		0
	),
	new Currency(
		'WST',
		'882',
		__( 'Samoan Tala', 'wpayme' ),
		'WS$',
		2
	),
	new Currency(
		'XAF',
		'950',
		__( 'CFA Franc BEAC', 'wpayme' ),
		'FCFA',
		0
	),
	new Currency(
		'XAG',
		'961',
		__( 'Silver', 'wpayme' ),
		'Ag oz t.',
		0
	),
	new Currency(
		'XAU',
		'959',
		__( 'Gold', 'wpayme' ),
		'Au oz t.',
		0
	),
	new Currency(
		'XBA',
		'955',
		__( 'Bond Markets Unit European Composite Unit (EURCO)', 'wpayme' ),
		null,
		0
	),
	new Currency(
		'XBB',
		'956',
		__( 'Bond Markets Unit European Monetary Unit (E.M.U.-6)', 'wpayme' ),
		null,
		0
	),
	new Currency(
		'XBC',
		'957',
		__( 'Bond Markets Unit European Unit of Account 9 (E.U.A.-9)', 'wpayme' ),
		null,
		0
	),
	new Currency(
		'XBD',
		'958',
		__( 'Bond Markets Unit European Unit of Account 17 (E.U.A.-17)', 'wpayme' ),
		null,
		0
	),
	new Currency(
		'XCD',
		'951',
		__( 'East Caribbean Dollar', 'wpayme' ),
		'$',
		2
	),
	new Currency(
		'XDR',
		'960',
		__( 'SDR (Special Drawing Right)', 'wpayme' ),
		'SDR',
		0
	),
	new Currency(
		'XOF',
		'952',
		__( 'CFA Franc BCEAO', 'wpayme' ),
		'CFA',
		0
	),
	new Currency(
		'XPD',
		'964',
		__( 'Palladium', 'wpayme' ),
		'Pd oz t.',
		0
	),
	new Currency(
		'XPF',
		'953',
		__( 'CFP Franc', 'wpayme' ),
		'F',
		0
	),
	new Currency(
		'XPT',
		'962',
		__( 'Platinum', 'wpayme' ),
		'Pt oz t.',
		0
	),
	new Currency(
		'XSU',
		'994',
		__( 'Sucre', 'wpayme' ),
		'Sucre',
		0
	),
	new Currency(
		'XTS',
		'963',
		__( 'Code reserved for testing', 'wpayme' ),
		null,
		0
	),
	new Currency(
		'XUA',
		'965',
		__( 'ADB Unit of Account', 'wpayme' ),
		null,
		0
	),
	new Currency(
		'XXX',
		'999',
		__( 'No currency', 'wpayme' ),
		null,
		0
	),
	new Currency(
		'YER',
		'886',
		__( 'Yemeni Rial', 'wpayme' ),
		'ر.ي',
		2
	),
	new Currency(
		'ZAR',
		'710',
		__( 'South African Rand', 'wpayme' ),
		'R',
		2
	),
	new Currency(
		'ZMW',
		'967',
		__( 'Zambian Kwacha', 'wpayme' ),
		'K',
		2
	),
	new Currency(
		'ZWL',
		'932',
		__( 'Zimbabwean Dollar', 'wpayme' ),
		'$',
		2
	),
];
