<?php
/**
 * Exception
 *
 * @author    Wpayme <hi@wpayme.com>
 * @copyright 2024-2025 Wpayme
 * @license   GPL-3.0-or-later
 * @package   Wpayme\WordPress\Http
 */

namespace Wpayme\WordPress\Http\Exceptions;

use Wpayme\WordPress\Http\Request;

/**
 * Exception
 *
 * @author  Remco Tolsma
 * @version 1.0.0
 * @since   1.0.0
 */
class Exception extends \Exception {
	/**
	 * Request.
	 *
	 * @var Request
	 */
	private $request;

	/**
	 * Construct exception.
	 *
	 * @param string  $message Message.
	 * @param Request $request Request.
	 */
	public function __construct( $message, $request ) {
		parent::__construct( $message );

		$this->request = $request;
	}

	/**
	 * Get request.
	 *
	 * @return Request
	 */
	public function get_request() {
		return $this->request;
	}
}
