<?php
/**
 * Attribute
 *
 * @author    Wpayme <hi@wpayme.com>
 * @copyright 2024-2025 Wpayme
 * @license   GPL-3.0-or-later
 * @package   Wpayme\WordPress\Html
 */

namespace Wpayme\WordPress\Html;

/**
 * Attribute
 *
 * @author Remco Tolsma
 * @version 1.0.0
 * @since 1.0.0
 */
class Attribute {
	/**
	 * Name.
	 *
	 * @var string
	 */
	private string $name;

	/**
	 * Value.
	 *
	 * @var string|null
	 */
	private ?string $value;

	/**
	 * Construct attribute.
	 *
	 * @param string      $name  Name.
	 * @param string|null $value Value.
	 */
	public function __construct( $name, $value = null ) {
		$this->name  = $name;
		$this->value = $value;
	}

	/**
	 * Is boolean attribute.
	 *
	 * @link https://www.w3.org/TR/html51/infrastructure.html#boolean-attribute
	 */
	public function is_boolean_attribute(): bool {
		return \in_array(
			$this->name,
			[
				'required',
				'disabled',
				'checked',
				'selected',
				'readonly',
				'multiple',
				'novalidate',
				'formnovalidate',
				'autofocus',
			],
			true
		);
	}

	/**
	 * To string.
	 *
	 * @return string
	 */
	public function __toString() {
		if ( $this->is_boolean_attribute() ) {
			return $this->name;
		}

		return $this->name . '="' . \esc_attr( \strval( $this->value ) ) . '"';
	}
}
