<?php
/**
 * Plugin Name: Gravity Forms (nl)
 * Plugin URI: https://www.wpayme.com/plugins/gravityforms-nl/
 * Description: Extend the Gravity Forms plugin with Dutch address and Euro sign notation.
 *
 * Version: 3.0.10
 * Requires at least: 3.0
 * Requires PHP: 7.4
 *
 * Author: Wpayme
 * Author URI: https://www.wpayme.com/
 *
 * Text Domain: gravityforms-nl
 * Domain Path: /languages/
 *
 * License: GPL
 *
 * GitHub URI: https://github.com/wpayme/wp-gravityforms-nl
 *
 * @author    Wpayme <hi@wpayme.com>
 * @copyright 2024-2025 Wpayme
 * @license   GPL-3.0-or-later
 * @package   Wpayme\WordPress\Pay
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Bootstrap.
 */
require __DIR__ . '/vendor/autoload.php';

add_action(
	'plugins_loaded',
	function () {
		if ( ! \class_exists( '\GFCommon' ) ) {
			return;
		}

		// Initialize.
		\Wpayme\WordPress\GravityFormsNL\Plugin::instance(
			[
				'file' => __FILE__,
			]
		);
	}
);
