<?php
// phpcs:disable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound

/**
 * Fundraising Progress Text block template.
 *
 * @author    Wpayme <hi@wpayme.com>
 * @copyright 2024-2025 Wpayme
 * @license   GPL-3.0-or-later
 * @package   Wpayme\WordPress\Pay
 */

namespace Wpayme\WordPress\Pay\Fundraising;

use Wpayme\WordPress\Money\Parser;

// Amount.
$parser = new Parser();

$raised_amount = $parser->parse( $attributes['raisedAmount'] );

// Currency.
if ( \array_key_exists( 'currencyCode', $attributes ) ) :
	$raised_amount->set_currency( $attributes['currencyCode'] );
endif;

?>
<div class="<?php echo esc_attr( Util::get_block_classes( $attributes, 'ppfr-block ppfr-block-compact' ) ); ?>" <?php echo wp_kses_data( get_block_wrapper_attributes() ); ?>>
	<dl class="ppfr-dl-list">
		<dt class="ppfr-dl-list__label"><?php echo \wp_kses_post( $attributes['raisedLabel'] ); ?></dt>
		<dd class="ppfr-dl-list__value" style="color:<?php echo \esc_attr( $attributes['color'] ); ?>"><?php echo \esc_html( $raised_amount->format_i18n_non_trailing_zeros() ); ?></dd>
		<dt class="ppfr-dl-list__label"><?php echo \wp_kses_post( $attributes['contributionsLabel'] ); ?></dt>
		<dd class="ppfr-dl-list__value"><?php echo intval( $attributes['contributionsValue'] ); ?></dd>
	</dl>
</div>
