<?php
/**
 * Plugin Name: WPayme Core
 * Plugin URI: https://www.wpayme.com/plugins/wpayme-pay-core/
 * Description: Core components for the WordPress payment processing library.
 *
 * Version: 4.25.0
 * Requires at least: 5.9
 * Requires PHP: 8.0
 *
 * Author: Wpayme
 * Author URI: https://www.wpayme.com/
 *
 * Text Domain: wpayme-pay-core
 * Domain Path: /languages/
 *
 * License: GPL-3.0-or-later
 *
 * GitHub URI: https://github.com/wpayme/wp-pay-core
 *
 * @author    Wpayme <hi@wpayme.com>
 * @copyright 2024-2025 Wpayme
 * @license   GPL-3.0-or-later
 * @package   Wpayme\WordPress\Pay
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Autoload.
 */
require_once __DIR__ . '/vendor/autoload_packages.php';

/**
 * Bootstrap.
 */
add_filter(
	'wpayme_pay_modules',
	function ( $modules ) {
		$modules[] = 'forms';
		$modules[] = 'subscriptions';

		return $modules;
	}
);

\Wpayme\WordPress\Pay\Plugin::instance(
	[
		'file'             => __FILE__,
		'action_scheduler' => __DIR__ . '/vendor/woocommerce/action-scheduler/action-scheduler.php',
	]
);
