<?php
/**
 * Widget Payment Status List
 *
 * @author    Wpayme <hi@wpayme.com>
 * @copyright 2024-2025 Wpayme
 * @license   GPL-3.0-or-later
 * @package   Wpayme\WordPress\Pay
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$wpayme_counts = \wp_count_posts( 'wpayme_payment' );

$wpayme_states = [
	'payment_completed' => [
		/* translators: %s: posts count value */
		'label' => __( '%s completed', 'wpayme' ),
		'icon'  => 'dashicons-yes-alt',
		'color' => '#4ADE80',
	],
	'payment_pending'   => [
		/* translators: %s: posts count value */
		'label' => __( '%s pending', 'wpayme' ),
		'icon'  => 'dashicons-clock',
		'color' => '#F59E0B',
	],
	'payment_cancelled' => [
		/* translators: %s: posts count value */
		'label' => __( '%s cancelled', 'wpayme' ),
		'icon'  => 'dashicons-dismiss',
		'color' => '#FB7185',
	],
	'payment_failed'    => [
		/* translators: %s: posts count value */
		'label' => __( '%s failed', 'wpayme' ),
		'icon'  => 'dashicons-warning',
		'color' => '#EF4444',
	],
	'payment_expired'   => [
		/* translators: %s: posts count value */
		'label' => __( '%s expired', 'wpayme' ),
		'icon'  => 'dashicons-calendar-alt',
		'color' => '#94A3B8',
	],
];

$wpayme_url = \add_query_arg(
	[
		'post_type' => 'wpayme_payment',
	],
	\admin_url( 'edit.php' )
);

?>
<div class="wpayme-pay-status-widget">
	<ul class="wpayme-pay-status-list">

		<?php foreach ( $wpayme_states as $wpayme_payment_status => $wpayme_status_info ) : ?>

			<li class="<?php echo \esc_attr( 'payment_status-' . $wpayme_payment_status ); ?>">
				<a href="<?php echo \esc_url( \add_query_arg( 'post_status', $wpayme_payment_status, $wpayme_url ) ); ?>">
					<span class="wpayme-status-icon" style="background-color: <?php echo esc_attr( $wpayme_status_info['color'] ); ?>">
						<span class="dashicons <?php echo esc_attr( $wpayme_status_info['icon'] ); ?>"></span>
					</span>
					<span class="wpayme-status-text">
					<?php
					$wpayme_count = isset( $wpayme_counts->$wpayme_payment_status ) ? $wpayme_counts->$wpayme_payment_status : 0;
					
					$wpayme_count_formatted = sprintf(
						/* translators: %s: Number payments */
						\_n( '%s payment', '%s payments', $wpayme_count, 'wpayme' ),
						\number_format_i18n( $wpayme_count )
					);
					
					$wpayme_label_without_count = str_replace('%s', '', $wpayme_status_info['label']);
					$wpayme_label_without_count = trim($wpayme_label_without_count);
					
					?>
					<span class="wpayme-status-tag" style="background-color: <?php echo esc_attr( $wpayme_status_info['color'] ); ?>">
						<?php echo esc_html( $wpayme_label_without_count ); ?>
					</span>
					<strong><?php echo esc_html( $wpayme_count_formatted ); ?></strong>
					</span>
				</a>
			</li>

		<?php endforeach; ?>

	</ul>
</div>
