<?php
/**
 * Subscription renew.
 *
 * @author    Wpayme <hi@wpayme.com>
 * @copyright 2024-2025 Wpayme
 * @license   GPL-3.0-or-later
 * @package   Wpayme\WordPress\Pay
 */

use Wpayme\WordPress\DateTime\DateTimeImmutable;
use Wpayme\WordPress\Pay\Subscriptions\SubscriptionPhase;
use Wpayme\WordPress\Pay\Subscriptions\SubscriptionStatus;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! isset( $subscription, $gateway ) ) {
	return;
}

$wpayme_pay_phase = $subscription->get_current_phase();

?>
<!DOCTYPE html>

<html <?php language_attributes(); ?>>
	<head>
		<meta charset="<?php bloginfo( 'charset' ); ?>" />

		<meta name="viewport" content="width=device-width, initial-scale=1.0">

		<title><?php esc_html_e( 'Subscription Renewal', 'wpayme' ); ?></title>

		<?php wp_print_styles( 'wpayme-pay-redirect' ); ?>
	</head>

	<body>
		<div class="wpayme-pay-redirect-page">
			<div class="wpayme-pay-redirect-container">
				<h1><?php esc_html_e( 'Subscription Renewal', 'wpayme' ); ?></h1>

				<div class="pp-page-section-container">
					<div class="pp-page-section-wrapper alignleft">
						<?php

						// Subscription details.
						require __DIR__ . '/subscription-details.php';

						// Determine next period.
						$wpayme_pay_phase = $subscription->get_current_phase();

						$wpayme_pay_now = new DateTimeImmutable();

						if (
								null !== $wpayme_pay_phase && $wpayme_pay_phase->get_next_date() < $wpayme_pay_now
									&&
								SubscriptionStatus::CANCELLED === $subscription->get_status() && 'gravityformsideal' === $subscription->get_source()
						) {
							$wpayme_pay_phase = new SubscriptionPhase( $subscription, $wpayme_pay_now, $wpayme_pay_phase->get_interval(), $wpayme_pay_phase->get_amount() );
						}

						$wpayme_pay_next_period = $wpayme_pay_phase->get_next_period();

						// Maybe use period from last failed payment.
						$wpayme_pay_renewal_period = $subscription->get_renewal_period();

						if ( null !== $wpayme_pay_renewal_period ) {
							$wpayme_pay_next_period = $wpayme_pay_renewal_period;
						}

						?>

						<?php if ( null === $wpayme_pay_next_period ) : ?>

							<p>
								<?php echo esc_html__( 'This subscription can not be renewed.', 'wpayme' ); ?>
							</p>

						<?php else : ?>

							<p>
								<?php

								printf(
									/* translators: %s: next period range */
									esc_html( __( 'Renew the subscription by paying for the period %s.', 'wpayme' ) ),
									esc_html( $wpayme_pay_next_period->human_readable_range( __( 'l j F Y', 'wpayme' ), _x( 'until', 'period separator', 'wpayme' ) ) )
								);

								?>
							</p>

							<form id="wpayme_form" name="wpayme_form" method="post">
								<?php wp_nonce_field( 'wpayme_pay_renew_subscription_' . $subscription->get_id(), 'wpayme_pay_renew_subscription_nonce' ); ?>

								<input type="submit" value="<?php esc_attr_e( 'Pay', 'wpayme' ); ?>"/>
							</form>

						<?php endif; ?>
					</div>
				</div>
			</div>
		</div>
	</body>
</html>
