<?php
/**
 * Subscription renew failed.
 *
 * @author    Wpayme <hi@wpayme.com>
 * @copyright 2024-2025 Wpayme
 * @license   GPL-3.0-or-later
 * @package   Wpayme\WordPress\Pay
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

?>
<!DOCTYPE html>

<html <?php language_attributes(); ?>>
	<head>
		<meta charset="<?php bloginfo( 'charset' ); ?>" />

		<meta name="viewport" content="width=device-width, initial-scale=1.0">

		<title><?php esc_html_e( 'Subscription Renewal', 'wpayme' ); ?></title>

		<?php wp_print_styles( 'wpayme-pay-redirect' ); ?>
	</head>

	<body>
		<div class="wpayme-pay-redirect-page">
			<div class="wpayme-pay-redirect-container">
				<h1><?php esc_html_e( 'Subscription Renewal', 'wpayme' ); ?></h1>

				<div class="pp-page-section-container">
					<div class="pp-page-section-wrapper">
						<p>
							<?php esc_html_e( 'The subscription can not be renewed.', 'wpayme' ); ?>
						</p>
					</div>
				</div>
			</div>
		</div>
	</body>
</html>
