<?php
/**
 * Subscription renew failed.
 *
 * @author    Wpayme <hi@wpayme.com>
 * @copyright 2024-2025 Wpayme
 * @license   GPL-3.0-or-later
 * @package   Wpayme\WordPress\Pay
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

?>
<!DOCTYPE html>

<html <?php language_attributes(); ?>>
	<head>
		<meta charset="<?php bloginfo( 'charset' ); ?>" />

		<meta name="viewport" content="width=device-width, initial-scale=1.0">

		<title><?php esc_html_e( 'Subscription Mandate', 'wpayme' ); ?></title>

		<?php wp_print_styles( 'wpayme-pay-redirect' ); ?>
	</head>

	<body>
		<div class="wpayme-pay-redirect-page">
			<div class="wpayme-pay-redirect-container alignleft">
				<p>
					<?php esc_html_e( 'The subscription has been updated.', 'wpayme' ); ?>
				</p>

				<p>
					<a href="<?php echo esc_url( home_url() ); ?>">
						<?php esc_html_e( 'Return to home page', 'wpayme' ); ?>
					</a>
				</p>
			</div>
		</div>
	</body>
</html>
