<?php
/**
 * Subscription info.
 *
 * @author    Wpayme <hi@wpayme.com>
 * @copyright 2024-2025 Wpayme
 * @license   GPL-3.0-or-later
 * @package   Wpayme\WordPress\Pay
 */

use Wpayme\WordPress\Pay\Core\PaymentMethods;
use Wpayme\WordPress\Pay\Util;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! isset( $subscription ) ) {
	return;
}

/*
 * Subscription details.
 */
$wpayme_pay_details = [
	[
		'term'        => __( 'Description', 'wpayme' ),
		'description' => $subscription->get_description(),
	],
];

// Current phase.
$wpayme_pay_phase = $subscription->get_current_phase();

$wpayme_pay_recurrence = '—';

if ( null !== $wpayme_pay_phase ) {
	// Amount.
	$wpayme_pay_details[] = [
		'term'        => __( 'Amount', 'wpayme' ),
		'description' => $wpayme_pay_phase->get_amount()->format_i18n(),
	];

	// Recurrence.
	if ( $wpayme_pay_phase->is_infinite() ) :
		// Infinite.
		$wpayme_pay_recurrence = Util::format_recurrences( $wpayme_pay_phase->get_interval() );

	elseif ( 1 !== $wpayme_pay_phase->get_total_periods() ) :
		// Fixed number of recurrences.
		$wpayme_pay_recurrence = sprintf(
			'%s (%s)',
			Util::format_recurrences( $wpayme_pay_phase->get_interval() ),
			Util::format_frequency( $wpayme_pay_phase->get_total_periods() )
		);

	endif;
}

// Payment method.
$wpayme_pay_payment_method = $subscription->get_payment_method();

if ( ! empty( $wpayme_pay_payment_method ) ) {
	$wpayme_pay_details[] = [
		'term'        => __( 'Payment method', 'wpayme' ),
		'description' => PaymentMethods::get_name( $wpayme_pay_payment_method ),
	];
}

// Recurrence.
$wpayme_pay_details[] = [
	'term'        => __( 'Recurrence', 'wpayme' ),
	'description' => $wpayme_pay_recurrence,
];

?>

<h2><?php esc_html_e( 'Subscription', 'wpayme' ); ?></h2>

<dl>
	<?php foreach ( $wpayme_pay_details as $wpayme_pay_detail ) : ?>

		<?php if ( array_key_exists( 'term', $wpayme_pay_detail ) ) : ?>

			<dt><?php echo esc_html( $wpayme_pay_detail['term'] ); ?></dt>

		<?php endif; ?>

		<?php if ( array_key_exists( 'description', $wpayme_pay_detail ) ) : ?>

			<dd><?php echo esc_html( $wpayme_pay_detail['description'] ); ?></dd>

		<?php endif; ?>

	<?php endforeach; ?>
</dl>
