<?php
/**
 * Subscription cancel.
 *
 * @author    Wpayme <hi@wpayme.com>
 * @copyright 2024-2025 Wpayme
 * @license   GPL-3.0-or-later
 * @package   Wpayme\WordPress\Pay
 */

use Wpayme\WordPress\Pay\Subscriptions\SubscriptionStatus;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! isset( $subscription ) ) {
	return;
}

$wpayme_pay_phase = $subscription->get_current_phase();

?>
<!DOCTYPE html>

<html <?php language_attributes(); ?>>
	<head>
		<meta charset="<?php bloginfo( 'charset' ); ?>" />

		<meta name="viewport" content="width=device-width, initial-scale=1.0">

		<title><?php esc_html_e( 'Subscription Cancellation', 'wpayme' ); ?></title>

		<?php wp_print_styles( 'wpayme-pay-redirect' ); ?>
	</head>

	<body>
		<div class="wpayme-pay-redirect-page">
			<div class="wpayme-pay-redirect-container">
				<h1><?php esc_html_e( 'Subscription Cancellation', 'wpayme' ); ?></h1>

				<div class="pp-page-section-container">
					<div class="pp-page-section-wrapper alignleft">

						<?php

						// Subscription details.
						require __DIR__ . '/subscription-details.php';

						?>

						<?php if ( SubscriptionStatus::ACTIVE !== $subscription->get_status() ) : ?>

							<p>
								<?php esc_html_e( 'The subscription can not be canceled as it is not active anymore.', 'wpayme' ); ?>
							</p>

						<?php endif; ?>
					</div>

					<?php if ( SubscriptionStatus::ACTIVE === $subscription->get_status() ) : ?>

						<div class="pp-page-section-wrapper">

							<p>
								<?php esc_html_e( 'Are you sure you want to cancel the subscription?', 'wpayme' ); ?>
							</p>

							<form id="wpayme_form" name="wpayme_form" method="post">
								<?php wp_nonce_field( 'wpayme_pay_cancel_subscription_' . $subscription->get_id(), 'wpayme_pay_cancel_subscription_nonce' ); ?>

								<input type="submit" value="<?php esc_attr_e( 'Cancel subscription', 'wpayme' ); ?>" />
							</form>

						</div>

					<?php endif; ?>
				</div>
			</div>
		</div>
	</body>
</html>
