<?php
/**
 * Redirect via HTML
 *
 * @author    Wpayme <hi@wpayme.com>
 * @copyright 2024-2025 Wpayme
 * @license   GPL-3.0-or-later
 * @package   Wpayme\WordPress\Pay
 * @var       \Wpayme\WordPress\Pay\Payments\Payment $payment Payment.
 * @var       \Wpayme\WordPress\Pay\Core\Gateway     $this    Gateway.
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

?>
<!DOCTYPE html>

<html <?php language_attributes(); ?>>
	<head>
		<meta charset="<?php bloginfo( 'charset' ); ?>" />

		<meta name="viewport" content="width=device-width, initial-scale=1.0">

		<title><?php esc_html_e( 'Redirecting…', 'wpayme' ); ?></title>

		<?php wp_print_styles( 'wpayme-pay-redirect' ); ?>
		<?php wp_print_scripts( 'wpayme-pay-redirect' ); ?>
	</head>

	<body>
		<div class="wpayme-pay-redirect-page">
			<div class="wpayme-pay-redirect-container">
				<h1><?php esc_html_e( 'Redirecting…', 'wpayme' ); ?></h1>

				<p>
					<?php esc_html_e( 'You will be automatically redirected to the online payment environment.', 'wpayme' ); ?>
				</p>

				<div class="pp-page-section-container">
					<div class="pp-page-section-wrapper">
						<p>
							<?php esc_html_e( 'Please click the button below if you are not automatically redirected.', 'wpayme' ); ?>
						</p>

						<?php $this->output_form( $payment ); ?>
					</div>
				</div>

				<div class="pp-page-section-container">
					<div class="pp-page-section-wrapper alignleft">
						<h2><?php esc_html_e( 'Payment', 'wpayme' ); ?></h2>

						<dl>
							<dt><?php esc_html_e( 'Date', 'wpayme' ); ?></dt>
							<dd><?php echo esc_html( $payment->get_date()->format_i18n() ); ?></dd>

							<?php $wpayme_transaction_id = $payment->get_transaction_id(); ?>

							<?php if ( ! empty( $wpayme_transaction_id ) ) : ?>

								<dt><?php esc_html_e( 'Transaction ID', 'wpayme' ); ?></dt>
								<dd><?php echo esc_html( $wpayme_transaction_id ); ?></dd>

							<?php endif; ?>

							<dt><?php esc_html_e( 'Description', 'wpayme' ); ?></dt>
							<dd><?php echo esc_html( (string) $payment->get_description() ); ?></dd>

							<dt><?php esc_html_e( 'Amount', 'wpayme' ); ?></dt>
							<dd><?php echo esc_html( $payment->get_total_amount()->format_i18n() ); ?></dd>
						</dl>
					</div>
				</div>
			</div>
		</div>
	</body>
</html>
