<?php
/**
 * Page Settings
 *
 * @author    Wpayme <hi@wpayme.com>
 * @copyright 2024-2025 Wpayme
 * @license   GPL-3.0-or-later
 * @package   Wpayme\WordPress\Pay
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// phpcs:ignore WordPress.Security.NonceVerification.Recommended
$wpayme_message_id = array_key_exists( 'message', $_GET ) ? \sanitize_text_field( \wp_unslash( $_GET['message'] ) ) : '';

if ( ! empty( $wpayme_message_id ) ) {
	switch ( $wpayme_message_id ) {
		case 'pages-generated':
			printf(
				'<div id="message" class="updated"><p>%s</p></div>',
				esc_html__( 'The default payment status pages are created.', 'wpayme' )
			);

			break;
		case 'pages-not-generated':
			printf(
				'<div id="message" class="error"><p>%s</p></div>',
				esc_html__( 'The default payment status pages could not be created.', 'wpayme' )
			);

			break;
	}
}

?>

<div class="wrap wpayme-pay-settings">
	<h1 class="wp-heading-inline"><?php echo esc_html( get_admin_page_title() ); ?></h1>

	<hr class="wp-header-end">

	<?php
		// Get current tab
		// phpcs:ignore WordPress.Security.NonceVerification.Recommended
		$wpayme_current_tab = isset( $_GET['tab'] ) ? sanitize_text_field( wp_unslash( $_GET['tab'] ) ) : 'general';
	?>

	<nav class="nav-tab-wrapper wpayme-nav-tab-wrapper">
		<a href="<?php echo esc_url( admin_url( 'admin.php?page=wpayme_pay_settings&tab=general' ) ); ?>" class="nav-tab <?php echo $wpayme_current_tab === 'general' ? 'nav-tab-active' : ''; ?>"><?php esc_html_e( 'General', 'wpayme' ); ?></a>
		<a href="<?php echo esc_url( admin_url( 'admin.php?page=wpayme_pay_settings&tab=email' ) ); ?>" class="nav-tab <?php echo $wpayme_current_tab === 'email' ? 'nav-tab-active' : ''; ?>"><?php esc_html_e( 'Email Settings', 'wpayme' ); ?></a>
	</nav>

	<form action="options.php" method="post">
		<?php wp_nonce_field( 'wpayme_pay_settings', 'wpayme_pay_nonce' ); ?>

		<?php
		if ( $wpayme_current_tab === 'general' ) {
			settings_fields( 'wpayme_pay' );
			do_settings_sections( 'wpayme_pay' );
		} elseif ( $wpayme_current_tab === 'email' ) {
			settings_fields( 'wpayme_pay_email' );
			do_settings_sections( 'wpayme_pay_email' );
		}
		?>

		<?php submit_button(); ?>
	</form>
</div>
