<?php
// phpcs:disable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
// phpcs:disable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedHooknameFound

/**
 * Page Dashboard
 *
 * @author    Wpayme <hi@wpayme.com>
 * @copyright 2024-2025 Wpayme
 * @license   GPL-3.0-or-later
 * @package   Wpayme\WordPress\Pay
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$wpayme_container_index = 1;

$css = "
/* Main Dashboard Heading */
.wrap h1 {
    font-size: 32px;
    font-weight: 700;
    color: #332e2e;
    margin: 25px 0 30px;
    padding: 15px 15px;
    display: flex;
    align-items: center;
    gap: 12px;
    border-left: 3px solid #4ADE80;
}

.wrap h1 .wpayme-icon {
    width: 32px;
    height: 32px;
}

/* Remove subheading styles and continue with existing styles */
.social-media-container {
	padding: 10px 0;
}
.social-media-title {
	margin-bottom: 15px;
	font-size: 14px;
}
.social-icons {
	display: flex;
	gap: 15px;
}
.social-icon {
	display: flex;
	align-items: center;
	justify-content: center;
	width: 36px;
	height: 36px;
	border-radius: 50%;
	background-color: #f5f5f5;
	transition: all 0.3s ease;
}
.social-icon:hover {
	background-color: #e0e0e0;
	transform: translateY(-2px);
}

/* Comparison Table */
.comparison-table-container {
	margin: 0 -12px;
	overflow-x: auto;
}
.comparison-table {
	width: 100%;
	border-collapse: separate;
	border-spacing: 0;
	border-radius: 6px;
	overflow: hidden;
	margin-bottom: 15px;
	box-shadow: 0 1px 3px rgba(0,0,0,0.05);
}
.comparison-table th {
	background-color: #f8f8f8;
	text-align: left;
	padding: 10px;
	border-bottom: 1px solid #e0e0e0;
	font-weight: 600;
}
.comparison-table th.premium-column {
	background-color: #edfaf0;
	color: #2B8A3E;
}
.comparison-table th:first-child {
	width: 45%;
}
.comparison-table th:not(:first-child) {
	width: 27.5%;
	text-align: center;
}
.comparison-table td {
	padding: 10px;
	border-bottom: 1px solid #f0f0f0;
	vertical-align: middle;
}
.comparison-table td:not(:first-child) {
	text-align: center;
}
.comparison-table td.premium-column {
	background-color: #f5fcf7;
	font-weight: 500;
}
.comparison-table tr:hover td {
	background-color: #f9f9f9;
}
.comparison-table tr:hover td.premium-column {
	background-color: #edfaf0;
}
.comparison-table .dashicons-yes {
	color: #40c057;
	font-size: 18px;
}
.comparison-table .dashicons-no {
	color: #ff6b6b;
	opacity: 0.5;
	font-size: 18px;
}
.price-comparison {
	display: flex;
	justify-content: space-between;
	margin: 20px 0;
	padding: 0 10px;
}
.free-price, .premium-price {
	display: flex;
	flex-direction: column;
	align-items: center;
	padding: 12px;
	border-radius: 8px;
	width: 45%;
}
.free-price {
	background-color: #f8f9fa;
	color: #495057;
}
.premium-price {
	background-color: #edfaf0;
	color: #2B8A3E;
	box-shadow: 0 4px 12px rgba(74, 222, 128, 0.2);
	transform: scale(1.05);
}
.price-label {
	font-size: 14px;
	font-weight: 500;
	margin-bottom: 4px;
}
.price-value {
	font-size: 24px;
	font-weight: 700;
	line-height: 1.2;
}
.price-period {
	font-size: 14px;
	font-weight: 400;
	opacity: 0.8;
}
.upgrade-button {
	display: block;
	text-align: center;
	background-color: #4ADE80;
	color: white !important;
	padding: 12px;
	border-radius: 6px;
	text-decoration: none;
	font-weight: 600;
	margin: 15px 10px;
	transition: all 0.3s ease;
	font-size: 15px;
	box-shadow: 0 4px 6px rgba(74, 222, 128, 0.2);
}
.upgrade-button:hover {
	background-color: #2B8A3E;
	transform: translateY(-2px);
	box-shadow: 0 6px 10px rgba(74, 222, 128, 0.3);
}

/* WPayme Status Box */
.wpayme-status-box {
	padding: 0 !important;
}

.postbox:has(.wpayme-status-box) {
	border-top: 4px solid #4ADE80 !important;
	box-shadow: 0 4px 10px rgba(0,0,0,0.05) !important;
}

/* Fallback for browsers that don't support :has() */
.postbox h2.hndle span:contains('WPayme Status') {
	border-top: 4px solid #4ADE80;
}

/* Free vs Premium Section */
.free-vs-premium-box {
	border-top: 4px solid #4ADE80 !important;
	box-shadow: 0 4px 10px rgba(0,0,0,0.05) !important;
	margin-bottom: 20px;
}

.comparison-table {
	width: 100%;
	border-collapse: separate;
	border-spacing: 0;
	border-radius: 6px;
	overflow: hidden;
	margin-bottom: 15px;
	box-shadow: 0 1px 3px rgba(0,0,0,0.05);
}

.comparison-table th {
	background-color: #f8f8f8;
	text-align: left;
	padding: 10px;
	border-bottom: 1px solid #e0e0e0;
	font-weight: 600;
}

.comparison-table th.premium-column {
	background-color: #edfaf0;
	color: #2B8A3E;
}

.comparison-table th:first-child {
	width: 45%;
}

.comparison-table th:not(:first-child) {
	width: 27.5%;
	text-align: center;
}

.comparison-table td {
	padding: 10px;
	border-bottom: 1px solid #f0f0f0;
	vertical-align: middle;
}

.comparison-table td:not(:first-child) {
	text-align: center;
}

.comparison-table td.premium-column {
	background-color: #f5fcf7;
	font-weight: 500;
}

.comparison-table tr:hover td {
	background-color: #f9f9f9;
}

.comparison-table tr:hover td.premium-column {
	background-color: #edfaf0;
}

.comparison-table .dashicons-yes {
	color: #40c057;
	font-size: 18px;
}

.comparison-table .dashicons-no {
	color: #ff6b6b;
	opacity: 0.5;
	font-size: 18px;
}

.price-comparison {
	display: flex;
	justify-content: space-between;
	margin: 20px 0;
	padding: 0 10px;
}

.free-price, .premium-price {
	display: flex;
	flex-direction: column;
	align-items: center;
	padding: 12px;
	border-radius: 8px;
	width: 45%;
}

.free-price {
	background-color: #f8f9fa;
	color: #495057;
}

.premium-price {
	background-color: #edfaf0;
	color: #2B8A3E;
	box-shadow: 0 4px 12px rgba(74, 222, 128, 0.2);
	transform: scale(1.05);
}

.price-label {
	font-size: 14px;
	font-weight: 500;
	margin-bottom: 4px;
}

.price-value {
	font-size: 24px;
	font-weight: 700;
	line-height: 1.2;
}

.price-period {
	font-size: 14px;
	font-weight: 400;
	opacity: 0.8;
}

.upgrade-button {
	display: block;
	text-align: center;
	background-color: #4ADE80;
	color: white !important;
	padding: 12px;
	border-radius: 6px;
	text-decoration: none;
	font-weight: 600;
	margin: 15px 10px;
	transition: all 0.3s ease;
	font-size: 15px;
	box-shadow: 0 4px 6px rgba(74, 222, 128, 0.2);
}

.upgrade-button:hover {
	background-color: #2B8A3E;
	transform: translateY(-2px);
	box-shadow: 0 6px 10px rgba(74, 222, 128, 0.3);
}

/* WPayme Status Box */
.wpayme-status-box {
	padding: 0 !important;
}

.postbox:has(.wpayme-status-box) {
	border-top: 4px solid #4ADE80 !important;
	box-shadow: 0 4px 10px rgba(0,0,0,0.05) !important;
}

/* Fallback for browsers that don't support :has() */
.postbox h2.hndle span:contains('WPayme Status') {
	border-top: 4px solid #4ADE80;
}

/* Lifetime Deal Section */
.lifetime-deal {
	margin: 25px 10px 10px;
	border: 2px dashed #ff6b6b;
	border-radius: 8px;
	overflow: hidden;
	position: relative;
}

.lifetime-deal-badge {
	background-color: #ff6b6b;
	color: white;
	padding: 6px 12px;
	font-size: 13px;
	font-weight: 600;
	display: flex;
	align-items: center;
	justify-content: center;
	gap: 5px;
}

.lifetime-deal-badge .dashicons {
	font-size: 16px;
	width: 16px;
	height: 16px;
	animation: flame 1.5s infinite alternate;
}

@keyframes flame {
	0% { transform: scale(1); opacity: 0.8; }
	100% { transform: scale(1.2); opacity: 1; }
}

.lifetime-button {
	display: flex;
	flex-direction: column;
	padding: 15px;
	text-decoration: none;
	color: #333;
	transition: all 0.3s ease;
}

.lifetime-button:hover {
	background-color: #fff8f8;
}

.lifetime-info {
	display: flex;
	flex-direction: column;
	align-items: center;
	margin-bottom: 12px;
}

.lifetime-label {
	font-size: 16px;
	font-weight: 600;
	margin-bottom: 8px;
	color: #333;
}

.lifetime-pricing {
	display: flex;
	align-items: center;
	gap: 10px;
	margin-bottom: 8px;
}

.original-price {
	font-size: 18px;
	font-weight: 500;
	color: #777;
	text-decoration: line-through;
	position: relative;
}

.original-price:after {
	content: '';
	position: absolute;
	top: 50%;
	left: -5%;
	width: 110%;
	height: 2px;
	background-color: #ff6b6b;
	transform: rotate(-5deg);
}

.current-price {
	font-size: 28px;
	font-weight: 700;
	color: #ff6b6b;
}

.lifetime-description {
	font-size: 13px;
	color: #666;
	text-align: center;
}

.lifetime-cta {
	background-color: #ff6b6b;
	color: white;
	padding: 10px;
	text-align: center;
	border-radius: 4px;
	font-weight: 600;
	font-size: 14px;
	transition: all 0.3s ease;
	margin-top: 5px;
}

.lifetime-button:hover .lifetime-cta {
	background-color: #ff5252;
	transform: translateY(-2px);
	box-shadow: 0 4px 8px rgba(255, 107, 107, 0.3);
}

/* WPayme News feed styling */
.wpayme-news-feed {
	margin: 0;
	padding: 0;
	list-style: none;
}

.wpayme-news-feed li {
	margin-bottom: 20px;
	padding-bottom: 20px;
	border-bottom: 1px solid #f0f0f0;
	transition: all 0.3s ease;
}

.wpayme-news-feed li:last-child {
	margin-bottom: 0;
	padding-bottom: 0;
	border-bottom: none;
}

.wpayme-news-feed .news-item-header {
	margin-bottom: 8px;
}

.wpayme-news-feed a {
	font-weight: 600;
	text-decoration: none;
	color: #2271b1;
	font-size: 14px;
	line-height: 1.4;
	transition: color 0.2s ease;
}

.wpayme-news-feed a:hover {
	color: #135e96;
}

.wpayme-news-feed .rss-date {
	display: block;
	color: #777;
	font-size: 12px;
	margin-bottom: 8px;
}

.wpayme-news-feed .rssSummary {
	font-size: 13px;
	line-height: 1.6;
	color: #555;
	margin-top: 8px;
}

.wpayme-news-feed .rssSummary p {
	margin: 0 0 8px 0;
}

.wpayme-news-feed .rssSummary p:last-child {
	margin-bottom: 0;
}

.error-message {
	color: #dc3232;
	background: #f8d7da;
	border: 1px solid #f5c6cb;
	padding: 12px;
	border-radius: 4px;
	margin: 10px 0;
	font-size: 13px;
	line-height: 1.5;
}

/* Getting Started Section */
.getting-started-box {
	border-top: 4px solid #4ADE80 !important;
	box-shadow: 0 4px 10px rgba(0,0,0,0.05) !important;
	margin-bottom: 20px;
}

.getting-started-box .inside {
	padding: 15px 20px;
}

.getting-started-box p {
	font-size: 14px;
	line-height: 1.5;
	margin-bottom: 15px;
	color: #555;
}

.getting-started-box .button-secondary {
	background-color: #f0f6fc;
	border: 1px solid #c5d9ed;
	color: #2271b1;
	padding: 8px 16px;
	margin: 0 8px 12px 0;
	border-radius: 4px;
	display: inline-flex;
	align-items: center;
	text-decoration: none;
	transition: all 0.2s ease;
	font-size: 13px;
	line-height: 1.4;
	font-weight: 500;
	box-shadow: 0 1px 2px rgba(0, 0, 0, 0.05);
}

.getting-started-box .button-secondary:hover {
	background-color: #e5f0fa;
	border-color: #2271b1;
	color: #135e96;
	box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
	transform: translateY(-1px);
}

.getting-started-box .button-secondary:focus {
	box-shadow: 0 0 0 1px #fff, 0 0 0 3px #2271b1;
	outline: none;
}

.getting-started-box .button-secondary .dashicons {
	font-size: 16px;
	width: 16px;
	height: 16px;
	margin-right: 8px;
	line-height: 1;
	position: relative;
	top: 1px;
	color: #2271b1;
}

.getting-started-box .button-secondary:hover .dashicons {
	color: #135e96;
}

.getting-started-box .start-tour {
	background-color: #2271b1;
	border-color: #135e96;
	padding: 8px 18px;
	font-weight: 600;
	box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
}

.getting-started-box .start-tour:hover {
	background-color: #135e96;
	border-color: #0d4973;
	box-shadow: 0 4px 6px rgba(0, 0, 0, 0.15);
}

.getting-started-box .start-tour:focus {
	box-shadow: 0 0 0 1px #fff, 0 0 0 3px #135e96;
}

/* Add these styles to your existing CSS */
.status-active {
	background-color: #edfaf0;
	color: #2B8A3E;
	padding: 4px 8px;
	border-radius: 4px;
	font-size: 12px;
	font-weight: 500;
	display: inline-block;
}

.status-pending {
	background-color: #fff3cd;
	color: #856404;
	padding: 4px 8px;
	border-radius: 4px;
	font-size: 12px;
	font-weight: 500;
	display: inline-block;
}

.wpayme_subscription_amount {
	font-weight: 500;
	color: #2271b1;
}

.wpayme_subscription_date {
	color: #666;
}

.wpayme_subscription_title strong {
	color: #1d2327;
}
";
wp_add_inline_style('wpayme-pay-admin', $css);

$script = "jQuery(document).ready(function($) {
	// Initialize all feature toggles as collapsed
	$('.wpayme-features-toggle').attr('aria-expanded', 'false');
	
	// Adjust layout for responsive design
	function adjustDashboardLayout() {
		var windowWidth = $(window).width();
		if (windowWidth < 782) {
			$('#postbox-container-1').css('width', '100%');
			$('#postbox-container-2').css('width', '100%');
		} else {
			$('#postbox-container-1').css('width', '68%');
			$('#postbox-container-2').css('width', '30%');
		}
	}
	
	// Run on page load and resize
	adjustDashboardLayout();
	$(window).resize(adjustDashboardLayout);
});";
wp_add_inline_script('wpayme-pay-admin', $script);

?>



<div class="wrap">
	<h1><img src="<?php echo esc_url( plugins_url( 'wpayme/images/wpaymeblack.svg' ) ); ?>" alt="WPayme" class="wpayme-icon"><?php echo esc_html( get_admin_page_title() ); ?></h1>

	<div id="dashboard-widgets-wrap">
		<div id="dashboard-widgets" class="metabox-holder">

			<?php if ( current_user_can( 'edit_payments' ) ) : ?>

				<!-- Left column for main functionality -->
				<div id="postbox-container-<?php echo \esc_attr( (string) $wpayme_container_index ); ?>" class="postbox-container" style="width:68%;">
					<div id="normal-sortables" class="meta-box-sortables ui-sortable">

						<?php if ( current_user_can( 'manage_options' ) ) : ?>
						<div class="postbox getting-started-box">
							<div class="postbox-header">
								<h2 class="hndle"><span><?php esc_html_e( 'Getting Started', 'wpayme' ); ?></span></h2>
							</div>

							<div class="inside">
								<p>
									<?php esc_html_e( "Please follow the tour, read the 'What is new' and 'Getting Started' pages before contacting us. Also, check the Site Health page for any issues.", 'wpayme' ); ?>
								</p>

								<?php

								// Start tour button
								$wpayme_start_nonce = wp_create_nonce('wpayme_pay_ignore_tour');
								printf(
									'<a href="%s" class="button-secondary start-tour"><span class="dashicons dashicons-welcome-learn-more"></span> %s</a>',
									esc_url(
										add_query_arg(
											[
												'page' => 'wpayme',
												'wpayme_pay_ignore_tour' => 'false',
												'wpayme_pay_nonce' => $wpayme_start_nonce,
											],
											admin_url('admin.php')
										)
									),
									esc_html__( 'Start tour', 'wpayme' )
								);

								echo ' ';

								if ( isset( $this ) && null !== $this->plugin->get_option( 'about_page_file' ) ) {
									printf(
										'<a href="%s" class="button-secondary"><span class="dashicons dashicons-megaphone"></span> %s</a>',
										esc_attr(
											add_query_arg(
												[
													'page' => 'wpayme-pay-about',
													'tab'  => 'new',
												]
											)
										),
										esc_html__( 'What is new', 'wpayme' )
									);

									echo ' ';

									printf(
										'<a href="%s" class="button-secondary"><span class="dashicons dashicons-book-alt"></span> %s</a>',
										esc_attr(
											add_query_arg(
												[
													'page' => 'wpayme-pay-about',
													'tab'  => 'getting-started',
												]
											)
										),
										esc_html__( 'Getting started', 'wpayme' )
									);

									echo ' ';
								}

								// Site Health button.
								if ( version_compare( get_bloginfo( 'version' ), '5.2', '>=' ) && current_user_can( 'view_site_health_checks' ) ) :

									printf(
										'<a href="%s" class="button-secondary"><span class="dashicons dashicons-heart"></span> %s</a>',
										esc_attr( get_admin_url( null, 'site-health.php' ) ),
										esc_html__( 'Site Health', 'wpayme' )
									);

								endif;

								// System Status button.
								if ( version_compare( get_bloginfo( 'version' ), '5.2', '<' ) ) :

									printf(
										'<a href="%s" class="button-secondary"><span class="dashicons dashicons-dashboard"></span> %s</a>',
										esc_attr(
											add_query_arg(
												[
													'page' => 'wpayme_pay_tools',
												]
											)
										),
										esc_html__( 'System Status', 'wpayme' )
									);

								endif;

								?>
							</div>
						</div>
						<?php endif; ?>

						<div class="postbox">
							<div class="postbox-header">
								<h2 class="hndle"><span><?php esc_html_e( 'WPayme Status', 'wpayme' ); ?></span></h2>
							</div>

							<div class="inside wpayme-status-box">
								<?php

								wpayme_pay_plugin()->admin->dashboard->status_widget();

								?>
							</div>
						</div>
					</div>

					<div id="normal-sortables" class="meta-box-sortables ui-sortable">

						<div class="postbox">
							<div class="postbox-header">
								<h2 class="hndle"><span><?php esc_html_e( 'Latest Payments', 'wpayme' ); ?></span></h2>
							</div>

							<div class="inside">
								<?php

								$wpayme_payments_post_type = \Wpayme\WordPress\Pay\Admin\AdminPaymentPostType::POST_TYPE;

								$wpayme_query = new WP_Query(
									[
										'post_type'      => $wpayme_payments_post_type,
										'post_status'    => \array_keys( \Wpayme\WordPress\Pay\Payments\PaymentPostType::get_payment_states() ),
										'posts_per_page' => 5,
									]
								);

								$wpayme_payment_posts = \array_filter(
									$wpayme_query->posts,
									function ( $post ) {
										return ( $post instanceof WP_Post );
									}
								);

								if ( count( $wpayme_payment_posts ) > 0 ) :

									$wpayme_columns = [
										'status',
										'subscription',
										'title',
										'amount',
										'date',
									];

									// phpcs:ignore WordPress.NamingConventions.ValidHookName.UseUnderscores
									$wpayme_column_titles = apply_filters( 'manage_edit-' . $wpayme_payments_post_type . '_columns', [] );

									?>

									<div id="dashboard_recent_drafts">
										<table class="wp-list-table widefat fixed striped posts">

											<tr class="type-<?php echo esc_attr( $wpayme_payments_post_type ); ?>">

												<?php

												foreach ( $wpayme_columns as $wpayme_column ) :
													$wpayme_custom_column = sprintf( '%1$s_%2$s', $wpayme_payments_post_type, $wpayme_column );

													// Column classes.
													$wpayme_classes = [
														sprintf( 'column-%s', $wpayme_custom_column ),
													];

													if ( 'wpayme_payment_title' === $wpayme_custom_column ) :
														$wpayme_classes[] = 'column-primary';
													endif;

													printf(
														'<th class="%1$s">%2$s</th>',
														esc_attr( implode( ' ', $wpayme_classes ) ),
														wp_kses_post( $wpayme_column_titles[ $wpayme_custom_column ] )
													);

												endforeach;

												?>

											</tr>

											<?php foreach ( $wpayme_payment_posts as $wpayme_payment_post ) : ?>

												<tr class="type-<?php echo esc_attr( $wpayme_payments_post_type ); ?>">
													<?php

													$wpayme_payment_id = $wpayme_payment_post->ID;

													// Loop columns.
													foreach ( $wpayme_columns as $wpayme_column ) :

														$wpayme_custom_column = sprintf( '%1$s_%2$s', $wpayme_payments_post_type, $wpayme_column );

														// Column classes.
														$wpayme_classes = [
															$wpayme_custom_column,
															'column-' . $wpayme_custom_column,
														];

														if ( 'wpayme_payment_title' === $wpayme_custom_column ) {
															$wpayme_classes[] = 'column-primary';
														}

														printf(
															'<td class="%1$s" data-colname="%2$s">',
															esc_attr( implode( ' ', $wpayme_classes ) ),
															esc_html( $wpayme_column_titles[ $wpayme_custom_column ] )
														);

														// Do custom column action.
														do_action(
															'manage_' . $wpayme_payments_post_type . '_posts_custom_column',
															$wpayme_custom_column,
															$wpayme_payment_id
														);

														if ( 'wpayme_payment_title' === $wpayme_custom_column ) :

															printf(
																'<button type = "button" class="toggle-row" ><span class="screen-reader-text">%1$s</span ></button>',
																esc_html( __( 'Show more details', 'wpayme' ) )
															);

														endif;

														echo '</td>';

													endforeach;

													?>

												</tr>

											<?php endforeach; ?>

										</table>
									</div>

									<?php wp_reset_postdata(); ?>

								<?php else : ?>

									<p><?php esc_html_e( 'No pending payments found.', 'wpayme' ); ?></p>

								<?php endif; ?>
							</div>
						</div>
					</div>

					<div id="normal-sortables" class="meta-box-sortables ui-sortable">
						<div class="postbox">
							<div class="postbox-header">
								<h2 class="hndle"><span><?php esc_html_e('Latest Subscriptions', 'wpayme'); ?></span></h2>
							</div>

							<div class="inside">
								<?php
								$wpayme_subscriptions_post_type = \Wpayme\WordPress\Pay\Admin\AdminSubscriptionPostType::POST_TYPE;

								$wpayme_query = new WP_Query(
									[
										'post_type'      => $wpayme_subscriptions_post_type,
										'post_status'    => \array_keys(\Wpayme\WordPress\Pay\Subscriptions\SubscriptionPostType::get_states()),
										'posts_per_page' => 5,
									]
								);

								$wpayme_subscriptions_posts = \array_filter(
									$wpayme_query->posts,
									function ($post) {
										return ($post instanceof WP_Post);
									}
								);

								if (count($wpayme_subscriptions_posts) > 0) :
									$wpayme_columns = [
										'status',
										'title',
										'amount',
										'date',
									];

									// phpcs:ignore WordPress.NamingConventions.ValidHookName.UseUnderscores
									$wpayme_column_titles = apply_filters('manage_edit-' . $wpayme_subscriptions_post_type . '_columns', []);

									?>

									<div id="dashboard_wpayme_pay_subscriptions">
										<table class="wp-list-table widefat fixed striped posts">
											<tr class="type-<?php echo esc_attr($wpayme_subscriptions_post_type); ?>">
												<?php
												foreach ($wpayme_columns as $wpayme_column) :
													$wpayme_custom_column = sprintf('%1$s_%2$s', 'wpayme_subscription', $wpayme_column);

													// Column classes.
													$wpayme_classes = [
														sprintf('column-%s', $wpayme_custom_column),
													];

													if ('wpayme_subscription_title' === $wpayme_custom_column) :
														$wpayme_classes[] = 'column-primary';
													endif;

													printf(
														'<th class="%1$s">%2$s</th>',
														esc_attr(implode(' ', $wpayme_classes)),
														wp_kses_post($wpayme_column_titles[$wpayme_custom_column])
													);

												endforeach;
												?>
											</tr>

											<!-- Dummy Subscription 1 -->
											<tr class="type-<?php echo esc_attr($wpayme_subscriptions_post_type); ?>">
												<td class="wpayme_subscription_status column-wpayme_subscription_status">
													<span class="status-active">Active</span>
												</td>
												<td class="wpayme_subscription_title column-wpayme_subscription_title column-primary">
													<strong>Premium Membership</strong>
													<button type="button" class="toggle-row"><span class="screen-reader-text">Show more details</span></button>
												</td>
												<td class="wpayme_subscription_amount column-wpayme_subscription_amount">
													€29.99/month
												</td>
												<td class="wpayme_subscription_date column-wpayme_subscription_date">
													<?php echo esc_html(gmdate('F j, Y')); ?>
												</td>
											</tr>

											<!-- Dummy Subscription 2 -->
											<tr class="type-<?php echo esc_attr($wpayme_subscriptions_post_type); ?>">
												<td class="wpayme_subscription_status column-wpayme_subscription_status">
													<span class="status-pending">Pending</span>
												</td>
												<td class="wpayme_subscription_title column-wpayme_subscription_title column-primary">
													<strong>Business Plan</strong>
													<button type="button" class="toggle-row"><span class="screen-reader-text">Show more details</span></button>
												</td>
												<td class="wpayme_subscription_amount column-wpayme_subscription_amount">
													€99.99/month
												</td>
												<td class="wpayme_subscription_date column-wpayme_subscription_date">
													<?php echo esc_html(gmdate('F j, Y', strtotime('-2 days'))); ?>
												</td>
											</tr>

											<!-- Dummy Subscription 3 -->
											<tr class="type-<?php echo esc_attr($wpayme_subscriptions_post_type); ?>">
												<td class="wpayme_subscription_status column-wpayme_subscription_status">
													<span class="status-active">Active</span>
												</td>
												<td class="wpayme_subscription_title column-wpayme_subscription_title column-primary">
													<strong>Enterprise Package</strong>
													<button type="button" class="toggle-row"><span class="screen-reader-text">Show more details</span></button>
												</td>
												<td class="wpayme_subscription_amount column-wpayme_subscription_amount">
													€199.99/month
												</td>
												<td class="wpayme_subscription_date column-wpayme_subscription_date">
													<?php echo esc_html(gmdate('F j, Y', strtotime('-5 days'))); ?>
												</td>
											</tr>

											<!-- Dummy Subscription 4 -->
											<tr class="type-<?php echo esc_attr($wpayme_subscriptions_post_type); ?>">
												<td class="wpayme_subscription_status column-wpayme_subscription_status">
													<span class="status-pending">Pending</span>
												</td>
												<td class="wpayme_subscription_title column-wpayme_subscription_title column-primary">
													<strong>Basic Plan</strong>
													<button type="button" class="toggle-row"><span class="screen-reader-text">Show more details</span></button>
												</td>
												<td class="wpayme_subscription_amount column-wpayme_subscription_amount">
													€9.99/month
												</td>
												<td class="wpayme_subscription_date column-wpayme_subscription_date">
													<?php echo esc_html(gmdate('F j, Y', strtotime('-1 day'))); ?>
												</td>
											</tr>

											<!-- Dummy Subscription 5 -->
											<tr class="type-<?php echo esc_attr($wpayme_subscriptions_post_type); ?>">
												<td class="wpayme_subscription_status column-wpayme_subscription_status">
													<span class="status-active">Active</span>
												</td>
												<td class="wpayme_subscription_title column-wpayme_subscription_title column-primary">
													<strong>Pro Plan</strong>
													<button type="button" class="toggle-row"><span class="screen-reader-text">Show more details</span></button>
												</td>
												<td class="wpayme_subscription_amount column-wpayme_subscription_amount">
													€49.99/month
												</td>
												<td class="wpayme_subscription_date column-wpayme_subscription_date">
													<?php echo esc_html(gmdate('F j, Y', strtotime('-3 days'))); ?>
												</td>
											</tr>

											<?php foreach ($wpayme_subscriptions_posts as $wpayme_subscription_post) : ?>
												<tr class="type-<?php echo esc_attr($wpayme_subscriptions_post_type); ?>">
													<?php
													$wpayme_subscription_id = $wpayme_subscription_post->ID;

													// Loop columns.
													foreach ($wpayme_columns as $wpayme_column) :
														$wpayme_custom_column = sprintf('%1$s_%2$s', 'wpayme_subscription', $wpayme_column);

														// Column classes.
														$wpayme_classes = [
															$wpayme_custom_column,
															'column-' . $wpayme_custom_column,
														];

														if ('wpayme_subscription_title' === $wpayme_custom_column) {
															$wpayme_classes[] = 'column-primary';
														}

														printf(
															'<td class="%1$s" data-colname="%2$s">',
															esc_attr(implode(' ', $wpayme_classes)),
															esc_html($wpayme_column_titles[$wpayme_custom_column])
														);

														// Do custom column action.
														do_action(
															'manage_' . $wpayme_subscriptions_post_type . '_posts_custom_column',
															$wpayme_custom_column,
															$wpayme_subscription_id
														);

														if ('wpayme_subscription_title' === $wpayme_custom_column) :
															printf(
																'<button type="button" class="toggle-row"><span class="screen-reader-text">%1$s</span></button>',
																esc_html(__('Show more details', 'wpayme'))
															);
														endif;

														echo '</td>';

													endforeach;
													?>
												</tr>
											<?php endforeach; ?>
										</table>
									</div>

									<?php wp_reset_postdata(); ?>

								<?php else : ?>
									<p><?php esc_html_e('No subscriptions found.', 'wpayme'); ?></p>
								<?php endif; ?>
							</div>
						</div>
					</div>

					<div id="normal-sortables" class="meta-box-sortables ui-sortable">
						<div class="postbox">
							<div class="postbox-header">
								<h2 class="hndle"><span><?php esc_html_e('WordPress News', 'wpayme'); ?></span></h2>
							</div>

							<div class="inside">
								<?php
								$wpayme_rss = fetch_feed('https://wordpress.com/blog/feed/');
								if (is_wp_error($wpayme_rss)) : ?>
									<p class="error-message">
										<?php echo esc_html($wpayme_rss->get_error_message()); ?>
									</p>
								<?php else :
									$wpayme_maxitems = $wpayme_rss->get_item_quantity(5);
									$wpayme_rss_items = $wpayme_rss->get_items(0, $wpayme_maxitems);
									if ($wpayme_maxitems > 0) : ?>
										<ul class="wpayme-news-feed">
											<?php foreach ($wpayme_rss_items as $wpayme_item) : ?>
												<li>
													<div class="news-item-header">
														<a href="<?php echo esc_url($wpayme_item->get_permalink()); ?>" target="_blank">
															<?php echo esc_html($wpayme_item->get_title()); ?>
														</a>
													</div>
													<span class="rss-date"><?php echo esc_html($wpayme_item->get_date('F j, Y')); ?></span>
													<div class="rssSummary"><?php echo wp_kses_post($wpayme_item->get_description()); ?></div>
												</li>
											<?php endforeach; ?>
										</ul>
									<?php else : ?>
										<p><?php esc_html_e('No news items available at the moment.', 'wpayme'); ?></p>
									<?php endif;
								endif; ?>
							</div>
						</div>
					</div>
				</div>

				<?php ++$wpayme_container_index; ?>

			<?php endif; ?>

			<div id="postbox-container-<?php echo \esc_attr( (string) $wpayme_container_index ); ?>" class="postbox-container" style="width:30%;">
				
				<div id="side-sortables" class="meta-box-sortables ui-sortable">
					
				</div>
			</div>

			<div class="clear"></div>
		</div>
	</div>
</div>


