<?php
/**
 * Meta Box Subscription Phases
 *
 * @author    Wpayme <hi@wpayme.com>
 * @copyright 2024-2025 Wpayme
 * @license   GPL-3.0-or-later
 * @package   Wpayme\WordPress\Pay
 */

use Wpayme\WordPress\Pay\Util;
use Wpayme\WordPress\Pay\Subscriptions\SubscriptionPhase;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

?>

<?php if ( empty( $phases ) ) : ?>

	<?php esc_html_e( 'No phases found.', 'wpayme' ); ?>

<?php else : ?>

	<?php

	$wpayme_has_trial     = false;
	$wpayme_has_alignment = false;

	foreach ( $phases as $wpayme_phase ) {
		if ( $wpayme_phase->is_trial() ) {
			$wpayme_has_trial = true;
		}

		if ( $wpayme_phase->is_alignment() || $wpayme_phase->is_prorated() ) {
			$wpayme_has_alignment = true;
		}
	}

	?>

	<div class="wpayme-pay-table-responsive">
		<table class="wpayme-pay-table widefat">
			<thead>
				<tr>
					<th scope="col"><?php esc_html_e( 'Amount', 'wpayme' ); ?></th>
					<th scope="col"><?php esc_html_e( 'Recurrence', 'wpayme' ); ?></th>
					<th scope="col"><?php esc_html_e( 'Start Date', 'wpayme' ); ?></th>
					<th scope="col"><?php esc_html_e( 'End Date', 'wpayme' ); ?></th>

					<?php if ( $wpayme_has_trial ) : ?>

						<th scope="col"><?php esc_html_e( 'Trial', 'wpayme' ); ?></th>

					<?php endif; ?>

					<?php if ( $wpayme_has_alignment ) : ?>

						<th scope="col"><?php esc_html_e( 'Aligned', 'wpayme' ); ?></th>
						<th scope="col"><?php esc_html_e( 'Prorated', 'wpayme' ); ?></th>

					<?php endif; ?>
				</tr>
			</thead>

			<tbody>

				<?php
				/**
				 * Subscription phase.
				 *
				 * @var SubscriptionPhase $wpayme_phase
				 */
				foreach ( $phases as $wpayme_phase ) :
					?>

					<tr>
						<td>
							<?php echo esc_html( $wpayme_phase->get_amount()->format_i18n() ); ?>
						</td>
						<td>
							<?php

							$wpayme_total_periods = $wpayme_phase->get_total_periods();

							if ( null === $wpayme_total_periods ) {
								// Unlimited.
								echo esc_html( strval( Util::format_recurrences( $wpayme_phase->get_interval() ) ) );
							}

							if ( 1 === $wpayme_total_periods ) {
								// No recurrence.
								echo '—';
							}

							if ( $wpayme_total_periods > 1 ) {
								// Fixed number of recurrences.
								printf(
									'%s (%s)',
									esc_html( strval( Util::format_recurrences( $wpayme_phase->get_interval() ) ) ),
									esc_html( strval( Util::format_frequency( $wpayme_total_periods ) ) )
								);
							}

							?>
						</td>
						<td>
							<?php

							$wpayme_start_date = $wpayme_phase->get_start_date();

							echo esc_html( ( new \Wpayme\WordPress\DateTime\DateTime( '@' . $wpayme_start_date->getTimestamp() ) )->format_i18n() );

							?>
						</td>
						<td>
							<?php

							$wpayme_end_date = $wpayme_phase->get_end_date();

							echo esc_html( null === $wpayme_end_date ? '∞' : ( new \Wpayme\WordPress\DateTime\DateTime( '@' . $wpayme_end_date->getTimestamp() ) )->format_i18n() );

							?>
						</td>

						<?php if ( $wpayme_has_trial ) : ?>

							<td>
								<?php

								echo esc_html( $wpayme_phase->is_trial() ? __( 'Yes', 'wpayme' ) : __( 'No', 'wpayme' ) );

								?>
							</td>

						<?php endif; ?>

						<?php if ( $wpayme_has_alignment ) : ?>

							<td>
								<?php

								echo esc_html( $wpayme_phase->is_alignment() ? __( 'Yes', 'wpayme' ) : __( 'No', 'wpayme' ) );

								?>
							</td>
							<td>
								<?php

								echo esc_html( $wpayme_phase->is_prorated() ? __( 'Yes', 'wpayme' ) : __( 'No', 'wpayme' ) );

								?>
							</td>

						<?php endif; ?>
					</tr>

				<?php endforeach; ?>

			</tbody>
		</table>
	</div>

<?php endif; ?>
