<?php
// phpcs:disable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound

/**
 * Meta Box Payment Update
 *
 * @author    Wpayme <hi@wpayme.com>
 * @copyright 2024-2025 Wpayme
 * @license   GPL-3.0-or-later
 * @package   Wpayme\WordPress\Pay
 */

use Wpayme\WordPress\Pay\Payments\PaymentStatus;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! isset( $post ) ) {
	return;
}

$wpayme_states = [
	PaymentStatus::OPEN       => _x( 'Pending', 'Payment status', 'wpayme' ),
	PaymentStatus::ON_HOLD    => _x( 'On Hold', 'Payment status', 'wpayme' ),
	PaymentStatus::SUCCESS    => _x( 'Completed', 'Payment status', 'wpayme' ),
	PaymentStatus::CANCELLED  => _x( 'Cancelled', 'Payment status', 'wpayme' ),
	PaymentStatus::REFUNDED   => _x( 'Refunded', 'Payment status', 'wpayme' ),
	PaymentStatus::FAILURE    => _x( 'Failed', 'Payment status', 'wpayme' ),
	PaymentStatus::EXPIRED    => _x( 'Expired', 'Payment status', 'wpayme' ),
	PaymentStatus::AUTHORIZED => _x( 'Authorized', 'Payment status', 'wpayme' ),
];

$wpayme_payment = \get_wpayme_payment( \get_the_ID() );

if ( null === $wpayme_payment ) {
	return;
}

ksort( $wpayme_states );

// WordPress by default doesn't allow `post_author` values of `0`, that's why we use a dash (`-`).
// @link https://github.com/WordPress/WordPress/blob/4.9.5/wp-admin/includes/post.php#L56-L64.
$wpayme_post_author = get_post_field( 'post_author' );
$wpayme_post_author = empty( $wpayme_post_author ) ? '-' : $wpayme_post_author;

?>
<input type="hidden" name="post_author_override" value="<?php echo esc_attr( $wpayme_post_author ); ?>" />

<div class="wpayme-pay-inner">
	<div id="minor-publishing-actions">
		<div class="clear"></div>
	</div>

	<div class="wpayme-pay-minor-actions">
		<div class="misc-pub-section misc-pub-post-status">
			<?php echo esc_html( __( 'Status:', 'wpayme' ) ); ?>

			<?php

			$wpayme_status_label = $wpayme_payment->get_status_label();

			$wpayme_status_label = ( null === $wpayme_status_label ) ? '—' : $wpayme_status_label;

			?>
			<span id="wpayme-pay-post-status-display"><?php echo esc_html( $wpayme_status_label ); ?></span>

			<a href="#wpayme-pay-post-status" class="edit-wpayme-pay-post-status hide-if-no-js" role="button">
				<span aria-hidden="true"><?php esc_html_e( 'Edit', 'wpayme' ); ?></span>
				<span class="screen-reader-text"><?php esc_html_e( 'Edit status', 'wpayme' ); ?></span>
			</a>

			<div id="wpayme-pay-post-status-input" class="hide-if-js">
				<label for="wpayme-pay-post-status" class="screen-reader-text"><?php esc_html_e( 'Set status', 'wpayme' ); ?></label>
				<select id="wpayme-pay-post-status" name="wpayme_payment_status">
					<?php

					foreach ( $wpayme_states as $payment_status => $label ) {
						printf(
							'<option value="%s" %s>%s</option>',
							esc_attr( $payment_status ),
							selected( $payment_status, $wpayme_payment->get_status(), false ),
							esc_html( $label )
						);
					}

					?>
				</select>

				<a href="#wpayme-pay-post-status" class="save-wpayme-pay-post-status hide-if-no-js button"><?php esc_html_e( 'OK', 'wpayme' ); ?></a>
				<a href="#wpayme-pay-post-status" class="cancel-wpayme-pay-post-status hide-if-no-js button-cancel"><?php esc_html_e( 'Cancel', 'wpayme' ); ?></a>
			</div>
		</div>

		<?php

		$wpayme_gateway = $wpayme_payment->get_gateway();

		/**
		 * Check status button.
		 */
		if ( null !== $wpayme_gateway && $wpayme_gateway->supports( 'payment_status_request' ) ) {
			// Only show button if gateway exists and status check is supported.
			$wpayme_action_url = wp_nonce_url(
				add_query_arg(
					[
						'post'                      => $post->ID,
						'action'                    => 'edit',
						'wpayme_pay_check_status' => true,
					],
					admin_url( 'post.php' )
				),
				'wpayme_payment_check_status_' . $post->ID
			);

			printf(
				'<div class="misc-pub-section"><a class="button" href="%s">%s</a></div>',
				esc_url( $wpayme_action_url ),
				esc_html__( 'Check status', 'wpayme' )
			);
		}

		?>
	</div>
</div>

<div class="wpayme-pay-major-actions">
	<div class="wpayme-pay-action">
		<?php

		wp_nonce_field( 'wpayme_payment_update', 'wpayme_payment_nonce' );

		printf(
			'<input type="hidden" name="wpayme_payment_id" value="%s" />',
			esc_attr( (string) $wpayme_payment->get_id() )
		);

		submit_button(
			__( 'Update', 'wpayme' ),
			'primary',
			'wpayme_payment_update',
			false
		);

		?>
	</div>

	<div class="clear"></div>
</div>
