<?php
// phpcs:disable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound

/**
 * Meta Box Payment Subscription
 *
 * @author    Wpayme <hi@wpayme.com>
 * @copyright 2024-2025 Wpayme
 * @license   GPL-3.0-or-later
 * @package   Wpayme\WordPress\Pay
 * @var \Wpayme\WordPress\Pay\Payments\Payment $payment Payment.
 */

use Wpayme\WordPress\Pay\Util;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$wpayme_subscriptions = $payment->get_subscriptions();

if ( empty( $wpayme_subscriptions ) ) : ?>

	<p>
		<?php esc_html_e( 'This payment is not related to a subscription.', 'wpayme' ); ?>
	</p>

<?php else : ?>

	<?php foreach ( $wpayme_subscriptions as $subscription ) : ?>

		<?php

		$wpayme_subscription_id = $subscription->get_id();

		$wpayme_phase = $subscription->get_display_phase();

		?>

		<table class="form-table">

			<?php if ( null !== $wpayme_subscription_id ) : ?>

				<tr>
					<th scope="row">
						<?php esc_html_e( 'Subscription', 'wpayme' ); ?>
					</th>
					<td>
						<?php edit_post_link( get_the_title( $wpayme_subscription_id ), '', '', $wpayme_subscription_id ); ?>
					</td>
				</tr>
				<tr>
					<th scope="row">
						<?php esc_html_e( 'Status', 'wpayme' ); ?>
					</th>
					<td>
						<?php

						$wpayme_status_object = get_post_status_object( (string) get_post_status( $wpayme_subscription_id ) );

						if ( isset( $wpayme_status_object, $wpayme_status_object->label ) ) {
							echo esc_html( $wpayme_status_object->label );
						} else {
							echo '—';
						}

						?>
					</td>
				</tr>

			<?php endif; ?>

			<tr>
				<th scope="row">
					<?php esc_html_e( 'Description', 'wpayme' ); ?>
				</th>
				<td>
					<?php echo esc_html( (string) $subscription->get_description() ); ?>
				</td>
			</tr>
			<tr>
				<th scope="row">
					<?php esc_html_e( 'Amount', 'wpayme' ); ?>
				</th>
				<td>
					<?php

					if ( null !== $wpayme_phase ) {
						echo esc_html( $wpayme_phase->get_amount()->format_i18n() );
					}

					?>
				</td>
			</tr>
			<tr>
				<th scope="row">
					<?php echo esc_html_x( 'Recurrence', 'Recurring payment', 'wpayme' ); ?>
				</th>
				<td>
					<?php

					$wpayme_total_periods = ( null === $wpayme_phase ) ? null : $wpayme_phase->get_total_periods();

					if ( null === $wpayme_phase || 1 === $wpayme_total_periods ) {
						// No recurrence.
						echo '—';
					} elseif ( null === $wpayme_total_periods ) {
						// Infinite.
						echo esc_html( strval( Util::format_recurrences( $wpayme_phase->get_interval() ) ) );
					} else {
						// Fixed number of recurrences.
						printf(
							'%s (%s)',
							esc_html( strval( Util::format_recurrences( $wpayme_phase->get_interval() ) ) ),
							esc_html( strval( Util::format_frequency( $wpayme_total_periods ) ) )
						);
					}

					?>
				</td>
			</tr>
			<tr>
				<th scope="row">
					<?php esc_html_e( 'Source', 'wpayme' ); ?>
				</th>
				<td>
					<?php

					echo wp_kses(
						$subscription->get_source_text(),
						[
							'a'  => [
								'href' => true,
							],
							'br' => [],
						]
					);

					?>
				</td>
			</tr>
		</table>

	<?php endforeach; ?>

<?php endif; ?>
