<?php
// phpcs:disable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound

/**
 * Meta Box Payment Refunds
 *
 * @author    Wpayme <hi@wpayme.com>
 * @copyright 2024-2025 Wpayme
 * @license   GPL-3.0-or-later
 * @package   Wpayme\WordPress\Pay
 */

namespace Wpayme\WordPress\Pay;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( empty( $payment->refunds ) ) : ?>

	<p>
		<?php \esc_html_e( 'No refunds found for this payment.', 'wpayme' ); ?>
	</p>

<?php else : ?>

	<div class="wpayme-pay-table-responsive">
		<table class="wpayme-pay-table widefat">
			<thead>
				<tr>
					<th scope="col"><?php \esc_html_e( 'Date', 'wpayme' ); ?></th>
					<th scope="col"><?php \esc_html_e( 'Amount', 'wpayme' ); ?></th>
					<th scope="col"><?php \esc_html_e( 'PSP ID', 'wpayme' ); ?></th>
					<th scope="col"><?php \esc_html_e( 'Description', 'wpayme' ); ?></th>
					<th scope="col"><?php \esc_html_e( 'User', 'wpayme' ); ?></th>
				</tr>
			</thead>

			<tfoot>
				<tr>
					<td></td>
					<td></td>
					<td></td>
					<td></td>
					<td></td>
				</tr>
			</tfoot>

			<tbody>

				<?php foreach ( $payment->refunds as $refund ) : ?>

					<tr>
						<td><?php echo \esc_html( $refund->created_at->format_i18n() ); ?></td>
						<td><?php echo \esc_html( $refund->get_amount()->format_i18n() ); ?></td>
						<td><?php echo \esc_html( $refund->psp_id ); ?></td>
						<td><?php echo \esc_html( $refund->get_description() ); ?></td>
						<td>
							<?php

							$wpayme_name = __( 'Unknown', 'wpayme' );

							if ( $refund->created_by->ID > 0 ) {
								$wpayme_name = $refund->created_by->display_name;
							}

							echo \esc_html( $wpayme_name );

							?>
						</td>
					</tr>

				<?php endforeach; ?>

			</tbody>
		</table>
	</div>

<?php endif; ?>
