<?php
// phpcs:disable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound

/**
 * Meta Box Payment Lines
 *
 * @author    Wpayme <hi@wpayme.com>
 * @copyright 2024-2025 Wpayme
 * @license   GPL-3.0-or-later
 * @package   Wpayme\WordPress\Pay
 */

namespace Wpayme\WordPress\Pay;

use Wpayme\WordPress\Money\Money;
use Wpayme\WordPress\Money\TaxedMoney;
use Wpayme\WordPress\Number\Number;
use Wpayme\WordPress\Pay\Payments\PaymentLine;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( empty( $lines ) ) : ?>

	<p>
		<?php \esc_html_e( 'No payment lines found.', 'wpayme' ); ?>
	</p>

<?php else : ?>

	<div class="wpayme-pay-table-responsive">
		<table class="wpayme-pay-table widefat">
			<thead>
				<tr>
					<th scope="col"><?php \esc_html_e( 'ID', 'wpayme' ); ?></th>
					<th scope="col"><?php \esc_html_e( 'SKU', 'wpayme' ); ?></th>
					<th scope="col"><?php \esc_html_e( 'Image', 'wpayme' ); ?></th>
					<th scope="col"><?php \esc_html_e( 'Name', 'wpayme' ); ?></th>
					<th scope="col">
						<?php

						\printf(
							'<span class="wpayme-pay-tip" title="%s">%s</span>',
							\esc_attr__( 'Unit price with discount including tax.', 'wpayme' ),
							\esc_html__( 'Unit Price', 'wpayme' )
						);

						?>
					</th>
					<th scope="col"><?php \esc_html_e( 'Quantity', 'wpayme' ); ?></th>
					<th scope="col">
						<?php

						\printf(
							'<span class="wpayme-pay-tip" title="%s">%s</span>',
							\esc_attr__( 'Total discount.', 'wpayme' ),
							\esc_html__( 'Discount', 'wpayme' )
						);

						?>
					</th>
					<th scope="col">
						<?php

						\printf(
							'<span class="wpayme-pay-tip" title="%s">%s</span>',
							\esc_attr__( 'Total amount with discount including tax.', 'wpayme' ),
							\esc_html__( 'Total Amount', 'wpayme' )
						);

						?>
					</th>
					<th scope="col"><?php \esc_html_e( 'Total Tax', 'wpayme' ); ?></th>
				</tr>
			</thead>

			<?php

			$wpayme_currency = $lines->get_amount()->get_currency();

			$wpayme_quantity_total          = new Number( 0 );
			$wpayme_tax_amount_total        = new Money( 0, $wpayme_currency );
			$wpayme_refunded_quantity_total = new Number( 0 );
			$wpayme_refunded_amount_total   = new Money( 0, $wpayme_currency );
			$wpayme_refunded_tax_total      = new Money( 0, $wpayme_currency );

			foreach ( $lines as $line ) {
				$wpayme_quantity = $line->get_quantity();

				if ( null !== $wpayme_quantity ) {
					$wpayme_quantity_total = $wpayme_quantity_total->add( Number::from_int( $wpayme_quantity ) );
				}

				$wpayme_total_amount = $line->get_total_amount();

				if ( $wpayme_total_amount instanceof TaxedMoney ) {
					$wpayme_tax_amount = $wpayme_total_amount->get_tax_amount();

					if ( null !== $wpayme_tax_amount ) {
						$wpayme_tax_amount_total = $wpayme_tax_amount_total->add( $wpayme_tax_amount );
					}
				}
			}

			if ( isset( $payment ) ) {
				foreach ( $payment->refunds as $wpayme_refund ) {
					foreach ( $wpayme_refund->lines as $wpayme_refund_line ) {
						$wpayme_refunded_quantity_total = $wpayme_refunded_quantity_total->add( $wpayme_refund_line->get_quantity() );

						$wpayme_line_total = $wpayme_refund_line->get_total_amount();

						$wpayme_refunded_amount_total = $wpayme_refunded_amount_total->add( $wpayme_refund_line->get_total_amount() );

						if ( $wpayme_line_total instanceof TaxedMoney ) {
							$wpayme_tax_amount = $wpayme_line_total->get_tax_amount();

							if ( null !== $wpayme_tax_amount ) {
								$wpayme_refunded_tax_total = $wpayme_refunded_tax_total->add( $wpayme_tax_amount );
							}
						}
					}
				}
			}

			?>

			<tfoot>
				<tr>
					<td></td>
					<td></td>
					<td></td>
					<td></td>
					<td></td>
					<td>
						<?php

						echo \esc_html( $wpayme_quantity_total->format_i18n() );

						if ( ! $wpayme_refunded_quantity_total->is_zero() ) {
							\printf( '<br><small class="wpayme-pay-text-negative">%s</small>', \esc_html( $wpayme_refunded_quantity_total->negative()->format_i18n() ) );
						}

						?>
					</td>
					<td>
						<?php

						$wpayme_values = \array_map(
							function ( PaymentLine $line ) {
								$wpayme_discount_amount = $line->get_discount_amount();

								return ( null === $wpayme_discount_amount ) ? null : $wpayme_discount_amount->get_value();
							},
							$lines->get_array()
						);

						$wpayme_discount_amount = new Money( \array_sum( $wpayme_values ), $lines->get_amount()->get_currency() );

						echo \esc_html( $wpayme_discount_amount->format_i18n() );

						?>
					</td>
					<td>
						<?php

						echo \esc_html( $lines->get_amount()->format_i18n() );

						if ( ! $wpayme_refunded_amount_total->get_number()->is_zero() ) {
							\printf( '<br><small class="wpayme-pay-text-negative">%s</small>', \esc_html( $wpayme_refunded_amount_total->negative()->format_i18n() ) );
						}

						?>
					</td>
					<td>
						<?php

						echo \esc_html( $wpayme_tax_amount_total->format_i18n() );

						if ( ! $wpayme_refunded_tax_total->get_number()->is_zero() ) {
							\printf( '<br><small class="wpayme-pay-text-negative">%s</small>', \esc_html( $wpayme_refunded_tax_total->negative()->format_i18n() ) );
						}

						?>
					</td>
				</tr>
			</tfoot>

			<tbody>

				<?php foreach ( $lines as $line ) : ?>

					<tr>
						<?php

						$wpayme_refunded_quantity = Number::from_int( 0 );
						$wpayme_refunded_amount   = new Money();
						$wpayme_refunded_tax      = new Money();

						if ( isset( $payment ) ) {
							foreach ( $payment->refunds as $wpayme_refund ) {
								foreach ( $wpayme_refund->lines as $wpayme_refund_line ) {
									if ( $wpayme_refund_line->get_payment_line() === $line ) {
										$wpayme_refunded_quantity = $wpayme_refunded_quantity->add( $wpayme_refund_line->get_quantity() );

										$wpayme_line_total = $wpayme_refund_line->get_total_amount();

										$wpayme_refunded_amount = $wpayme_refunded_amount->add( $wpayme_line_total );

										if ( $wpayme_line_total instanceof TaxedMoney ) {
											$wpayme_tax_amount = $wpayme_line_total->get_tax_amount();

											if ( null !== $wpayme_tax_amount ) {
												$wpayme_refunded_tax = $wpayme_refunded_tax->add( $wpayme_tax_amount );
											}
										}
									}
								}
							}
						}

						?>
						<td><?php echo \esc_html( $line->get_id() ); ?></td>
						<td><?php echo \esc_html( $line->get_sku() ); ?></td>
						<td>
							<?php

							$wpayme_image_url = $line->get_image_url();

							if ( ! empty( $wpayme_image_url ) ) {
								\printf(
									'<img src="%s" alt="" width="50" height="50" />',
									\esc_url( $wpayme_image_url )
								);
							}

							?>
						</td>
						<td>
							<?php

							$wpayme_product_url = $line->get_product_url();

							$wpayme_description = $line->get_description();

							if ( ! empty( $wpayme_product_url ) ) {
								// Product URL with or without description.
								$wpayme_line_title = $line->get_name();

								$wpayme_classes = [];

								if ( ! empty( $wpayme_description ) ) {
									$wpayme_line_title = $line->get_description();
									$wpayme_classes[]  = 'wpayme-pay-tip';
								}

								\printf(
									'<a class="%1$s" href="%2$s" title="%3$s">%4$s<a/>',
									\esc_attr( \implode( ' ', $wpayme_classes ) ),
									\esc_url( $line->get_product_url() ),
									\esc_attr( $wpayme_line_title ),
									\esc_html( $line->get_name() )
								);
							} elseif ( ! empty( $wpayme_description ) ) {
								// Description without product URL.
								\printf(
									'<span class="wpayme-pay-tip" title="%1$s">%2$s</span>',
									\esc_attr( $line->get_description() ),
									\esc_html( $line->get_name() )
								);
							} else {
								// No description and no product URL.
								echo \esc_html( $line->get_name() );
							}

							?>
						</td>
						<td>
							<?php

							$wpayme_unit_price = $line->get_unit_price();

							if ( null !== $wpayme_unit_price ) {
								$wpayme_tips = [
									\__( 'No tax information.', 'wpayme' ),
								];

								if ( $wpayme_unit_price instanceof TaxedMoney ) {
									$wpayme_tips = [
										\sprintf(
											/* translators: %s: price excluding tax */
											\__( 'Exclusive tax: %s', 'wpayme' ),
											$wpayme_unit_price->get_excluding_tax()
										),
										\sprintf(
											/* translators: %s: price including tax */
											\__( 'Inclusive tax: %s', 'wpayme' ),
											$wpayme_unit_price->get_including_tax()
										),
									];
								}

								\printf(
									'<span class="wpayme-pay-tip" title="%s">%s</span>',
									\esc_attr( \implode( '<br />', $wpayme_tips ) ),
									\esc_html( $wpayme_unit_price->format_i18n() )
								);

							}

							?>
						</td>
						<td>
							<?php

							echo \esc_html( $line->get_quantity() );

							if ( ! $wpayme_refunded_quantity->is_zero() ) {
								\printf( '<br><small class="wpayme-pay-text-negative">%s</small>', \esc_html( $wpayme_refunded_quantity->negative()->format_i18n() ) );
							}

							?>
						</td>
						<td>
							<?php

							$wpayme_discount_amount = $line->get_discount_amount();

							if ( null !== $wpayme_discount_amount ) {
								echo \esc_html( $wpayme_discount_amount );
							}

							?>
						</td>
						<td>
							<?php

							$wpayme_line_total = $line->get_total_amount();

							$wpayme_tips = [
								\__( 'No tax information.', 'wpayme' ),
							];

							if ( $wpayme_line_total instanceof TaxedMoney ) {
								$wpayme_tips = [
									\sprintf(
										/* translators: %s: price excluding tax */
										\__( 'Exclusive tax: %s', 'wpayme' ),
										$line->get_total_amount()->get_excluding_tax()
									),
									\sprintf(
										/* translators: %s: price including tax */
										\__( 'Inclusive tax: %s', 'wpayme' ),
										$line->get_total_amount()->get_including_tax()
									),
								];
							}

							\printf(
								'<span class="wpayme-pay-tip" title="%s">%s</span>',
								\esc_attr( \implode( '<br />', $wpayme_tips ) ),
								\esc_html( $wpayme_line_total->format_i18n() )
							);

							if ( ! $wpayme_refunded_amount->get_number()->is_zero() ) {
								\printf( '<br><small class="wpayme-pay-text-negative">%s</small>', \esc_html( $wpayme_refunded_amount->negative()->format_i18n() ) );
							}

							?>
						</td>
						<td>
							<?php

							if ( $wpayme_line_total instanceof TaxedMoney ) {
								$wpayme_tax_amount     = $wpayme_line_total->get_tax_amount();
								$wpayme_tax_percentage = $wpayme_line_total->get_tax_percentage();

								if ( null !== $wpayme_tax_amount ) {
									$wpayme_tip = '';

									if ( null !== $wpayme_tax_percentage ) {
										$wpayme_number = Number::from_mixed( $wpayme_tax_percentage );

										$wpayme_tip = $wpayme_number->format_i18n() . '%';
									}

									\printf(
										'<span class="wpayme-pay-tip" title="%s">%s</span>',
										\esc_attr( $wpayme_tip ),
										\esc_html( $wpayme_tax_amount->format_i18n() )
									);
								}
							}

							if ( ! $wpayme_refunded_tax->get_number()->is_zero() ) {
								\printf( '<br><small class="wpayme-pay-text-negative">%s</small>', \esc_html( $wpayme_refunded_tax->negative()->format_i18n() ) );
							}

							?>
						</td>
					</tr>

				<?php endforeach; ?>

			</tbody>
		</table>
	</div>

<?php endif; ?>
