<?php
// phpcs:disable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound

/**
 * Meta Box Payment Notes
 *
 * @author    Wpayme <hi@wpayme.com>
 * @copyright 2024-2025 Wpayme
 * @license   GPL-3.0-or-later
 * @package   Wpayme\WordPress\Pay
 */

namespace Wpayme\WordPress\Pay;

use Wpayme\WordPress\DateTime\DateTime;
use Wpayme\WordPress\DateTime\DateTimeZone;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! isset( $notes ) ) {
	return;
}

if ( ! is_array( $notes ) ) {
	return;
}

if ( empty( $notes ) ) : ?>

	<?php esc_html_e( 'No notes found.', 'wpayme' ); ?>

<?php else : ?>

	<table class="wpayme-pay-table widefat">
		<thead>
			<tr>
				<th scope="col"><?php esc_html_e( 'Date', 'wpayme' ); ?></th>
				<th scope="col"><?php esc_html_e( 'Note', 'wpayme' ); ?></th>
				<th scope="col"><?php esc_html_e( 'User', 'wpayme' ); ?></th>
			</tr>
		</thead>

		<tbody>

			<?php foreach ( $notes as $note ) : ?>

				<tr>
					<td>
						<?php

						$wpayme_date = new DateTime( $note->comment_date_gmt, new DateTimeZone( 'UTC' ) );

						echo esc_html( $wpayme_date->format_i18n() );

						?>
					</td>
					<td>
						<?php comment_text( $note ); ?>
					</td>
					<td>
						<?php comment_author( $note ); ?>
					</td>
				</tr>

			<?php endforeach; ?>

		</tbody>
	</table>

<?php endif; ?>
