<?php
/**
 * Meta box gateway config payment methods.
 *
 * @author    Wpayme <hi@wpayme.com>
 * @copyright 2024-2025 Wpayme
 * @license   GPL-3.0-or-later
 * @package   Wpayme\WordPress\Pay
 * @var array<string, string> $columns                  Columns.
 * @var array                 $payment_methods          Payment methods.
 * @var bool                  $supports_methods_request Supports methods request.
 */

use Wpayme\WordPress\Pay\Core\PaymentMethods;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$wpayme_show_recurring_column = false;

foreach ( $payment_methods as $wpayme_payment_method ) {
	if ( $wpayme_payment_method->supports( 'recurring' ) ) {
		$wpayme_show_recurring_column = true;

		break;
	}
}

?>
<table class="form-table widefat wpayme-pay-payment-methods">
	<thead>
		<tr>
			<th scope="col"><?php esc_html_e( 'Payment Method', 'wpayme' ); ?></th>
			<th scope="col"><?php esc_html_e( 'Status', 'wpayme' ); ?></th>

			<?php if ( $wpayme_show_recurring_column ) : ?>

				<th scope="col"><?php esc_html_e( 'Recurring', 'wpayme' ); ?></th>

			<?php endif; ?>
		</tr>
	</thead>

	<tbody>

		<?php foreach ( $payment_methods as $wpayme_payment_method ) : ?>

			<tr>
				<td>
					<?php echo esc_html( $wpayme_payment_method->get_name() ); ?>
				</td>
				<td>
					<?php

					$wpayme_icon = 'question-mark';

					switch ( $wpayme_payment_method->get_status() ) {
						case 'active':
							$wpayme_icon = 'completed';
							break;
						case 'inactive':
							$wpayme_icon = 'cancelled';
							break;
					}

					printf( '<span class="wpayme-pay-icon wpayme-pay-icon-%s"></span>', esc_attr( $wpayme_icon ) );

					?>
				</td>

				<?php if ( $wpayme_show_recurring_column ) : ?>

					<td>
						<?php

						$wpayme_icon = 'cancelled';

						if ( $wpayme_payment_method->supports( 'recurring' ) ) {
							$wpayme_icon = 'completed';
						}

						printf( '<span class="wpayme-pay-icon wpayme-pay-icon-%s"></span>', esc_attr( $wpayme_icon ) );

						?>
					</td>

				<?php endif; ?>

			</tr>

		<?php endforeach; ?>

	</tbody>
</table>
