<?php
// phpcs:disable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound

/**
 * Form
 *
 * @author    Wpayme <hi@wpayme.com>
 * @copyright 2024-2025 Wpayme
 * @license   GPL-3.0-or-later
 * @package   Wpayme\WordPress\Pay
 * @var       \Wpayme\WordPress\Pay\Payments\Payment $payment Payment.
 * @var       \Wpayme\WordPress\Pay\Core\Gateway     $this    Gateway.
 */

use Wpayme\WordPress\Html\Element;
use Wpayme\WordPress\Pay\Util;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$action_url = $payment->get_action_url();

if ( empty( $action_url ) ) {
	esc_html_e( 'It is currently not possible to pay, please contact us for more information (error: no action URL found).', 'wpayme' );

	return;
}

?>
<form id="wpayme_form" name="wpayme_form" method="post" action="<?php echo esc_url( $action_url ); ?>">
	<?php

	$data = $this->get_output_fields( $payment );

	$data = Util::array_square_bracket( $data );

	foreach ( $data as $name => $value ) {
		printf(
			'<input type="hidden" name="%s" value="%s" />',
			esc_attr( $name ),
			esc_attr( $value )
		);
	}

	?>

	<input class="wpayme-pay-btn" type="submit" name="pay" value="<?php esc_attr_e( 'Pay', 'wpayme' ); ?>" />
</form>

<?php

$auto_submit = true;

if ( defined( 'WPAYME_PAY_DEBUG' ) && WPAYME_PAY_DEBUG ) {
	$auto_submit = false;
}

if ( $auto_submit ) {
	$element = new Element(
		'script',
		[
			'type' => 'text/javascript',
		]
	);

	$element->children[] = 'document.wpayme_form.submit();';

	$element->output();
}
