<?php
// phpcs:disable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound

/**
 * Exception
 *
 * @author    Wpayme <hi@wpayme.com>
 * @copyright 2024-2025 Wpayme
 * @license   GPL-3.0-or-later
 * @package   Wpayme\WordPress\Pay
 * @var       \Exception $exception Exception.
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

?>

<div class="error">
	<dl>
		<dt><?php esc_html_e( 'Message', 'wpayme' ); ?></dt>
		<dd><?php echo esc_html( $exception->getMessage() ); ?></dd>

		<?php if ( 0 !== $exception->getCode() ) : ?>

			<dt><?php esc_html_e( 'Code', 'wpayme' ); ?></dt>
			<dd><?php echo esc_html( $exception->getCode() ); ?></dd>

		<?php endif; ?>

		<?php if ( wpayme_pay_plugin()->is_debug_mode() && current_user_can( 'manage_options' ) ) : ?>

			<dt><?php esc_html_e( 'Trace', 'wpayme' ); ?></dt>
			<dd>
				<?php

				echo '<pre>';
				echo esc_html( $exception->getTraceAsString() );
				echo '</pre>';

				?>
			</dd>

		<?php endif; ?>
	</dl>
</div>

<?php

$exception = $exception->getPrevious();

if ( null !== $exception ) {
	require __FILE__;
}
