<?php
/**
 * Merge Tag
 *
 * @author    Wpayme <hi@wpayme.com>
 * @copyright 2024-2025 Wpayme
 * @license   GPL-3.0-or-later
 * @package   Wpayme\WordPress\Pay\Gateways
 */

namespace Wpayme\WordPress\Pay\MergeTags;

/**
 * Merge Tag class
 */
class MergeTag {
	/**
	 * Slug of this merge tag.
	 *
	 * @var string
	 */
	private $slug;

	/**
	 * Resolver.
	 *
	 * @var callable
	 */
	private $resolver;

	/**
	 * Construct merge tag.
	 *
	 * @param string   $slug     Slug.
	 * @param callable $resolver Resolver.
	 */
	public function __construct( $slug, $resolver ) {
		$this->slug     = $slug;
		$this->resolver = $resolver;
	}

	/**
	 * Get slug.
	 *
	 * @return string
	 */
	public function get_slug() {
		return $this->slug;
	}

	/**
	 * Resolve.
	 *
	 * @return string
	 */
	public function resolve() {
		return \call_user_func( $this->resolver );
	}
}
