<?php
/**
 * Select field option group
 *
 * @author    Wpayme <hi@wpayme.com>
 * @copyright 2024-2025 Wpayme
 * @license   GPL-3.0-or-later
 * @package   Wpayme\WordPress\Pay\Core
 */

namespace Wpayme\WordPress\Pay\Fields;

use Wpayme\WordPress\Html\Element;

/**
 * Select field option group class
 */
class SelectFieldOptionGroup {
	/**
	 * Label.
	 *
	 * @var string
	 */
	private $label;

	/**
	 * Options.
	 *
	 * @var SelectFieldOption[]
	 */
	public $options = [];

	/**
	 * Construct select field option group.
	 *
	 * @param string $label Label.
	 */
	public function __construct( $label ) {
		$this->label = $label;
	}

	/**
	 * Get element.
	 *
	 * @return Element
	 */
	public function get_element() {
		$element = new Element(
			'optgroup',
			[
				'label' => $this->label,
			]
		);

		foreach ( $this->options as $option ) {
			$element->children[] = $option->get_element();
		}

		return $element;
	}
}
