<?php
/**
 * Select field iDEAL issuer
 *
 * @author    Wpayme <hi@wpayme.com>
 * @copyright 2024-2025 Wpayme
 * @license   GPL-3.0-or-later
 * @package   Wpayme\WordPress\Pay\Core
 */

namespace Wpayme\WordPress\Pay\Fields;

/**
 * Select field iDEAL issuer class
 */
class IDealIssuerSelectField extends SelectField {
	/**
	 * Setup.
	 *
	 * @return void
	 */
	protected function setup() {
		parent::setup();

		$this->meta_key = 'issuer';

		$this->set_label( \__( 'Bank', 'wpayme' ) );
	}

	/**
	 * Get options.
	 *
	 * @return array<SelectFieldOption|SelectFieldOptionGroup>
	 */
	public function get_options() {
		$options = parent::get_options();

		return [
			/**
			 * The list should be accompanied by the instruction phrase "Kies uw bank" (UK: "Choose your bank"). In
			 * case of an HTML <SELECT>, the first element in the list states this instruction phrase and is selected by default (to prevent accidental Issuer selection).
			 */
			new SelectFieldOption( '', __( '— Choose your bank —', 'wpayme' ) ),

			...$options,
		];
	}
}
