<?php
/**
 * Date field
 *
 * @author    Wpayme <hi@wpayme.com>
 * @copyright 2024-2025 Wpayme
 * @license   GPL-3.0-or-later
 * @package   Wpayme\WordPress\Pay\Core
 */

namespace Wpayme\WordPress\Pay\Fields;

use Wpayme\WordPress\Html\Element;

/**
 * Date field class
 */
class DateField extends Field {
	/**
	 * Get element.
	 *
	 * @return Element|null
	 */
	protected function get_element() {
		$element = new Element(
			'input',
			[
				'type' => 'date',
				'id'   => $this->get_id(),
				'name' => $this->get_id(),
			]
		);

		return $element;
	}

	/**
	 * Serialize to JSON.
	 *
	 * @return mixed
	 */
	#[\ReturnTypeWillChange]
	public function jsonSerialize() {
		$data = parent::jsonSerialize();

		$data['type'] = 'date';

		return $data;
	}
}
