<?php
/**
 * Dependencies
 *
 * @author    Wpayme <hi@wpayme.com>
 * @copyright 2024-2025 Wpayme
 * @license   GPL-3.0-or-later
 * @package   Wpayme\WordPress\Pay\Dependencies
 */

namespace Wpayme\WordPress\Pay\Dependencies;

/**
 * Dependencies
 *
 * @author  Remco Tolsma
 * @version 2.2.6
 * @since   2.2.6
 */
class Dependencies {
	/**
	 * Dependencies.
	 *
	 * @var array<Dependency>
	 */
	private $dependencies;

	/**
	 * Construct.
	 */
	public function __construct() {
		$this->dependencies = [];
	}

	/**
	 * Add dependency.
	 *
	 * @param Dependency $dependency The dependency to add.
	 * @return void
	 */
	public function add( Dependency $dependency ) {
		$this->dependencies[] = $dependency;
	}

	/**
	 * Are met.
	 *
	 * @return bool True if dependencies are met, false otherwise.
	 */
	public function are_met() {
		foreach ( $this->dependencies as $dependency ) {
			if ( ! $dependency->is_met() ) {
				return false;
			}
		}

		return true;
	}
}
